/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.resource.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.XMLWellFormedData;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.resource.Resource;
import org.xml.sax.InputSource;

public class ServletResource
extends Resource {
    private static String SERVLET_RESOURCE = "servlet:/";
    private ServletContext context = null;

    public void init(String resourceId) {
        this.resourceId = resourceId.substring(SERVLET_RESOURCE.length());
    }

    public void setContext(Object context) {
        if (!(context instanceof ServletContext)) {
            throw new ClassCastException("ServletResource.setContext():" + context.getClass().getName() + " not subclass of javax.servlet.ServletContext!");
        }
        this.context = (ServletContext)context;
    }

    public XMLWellFormedData load() throws UniFormTransformationException, IOException {
        try {
            WellFormedUniFormTree tree = new WellFormedUniFormTree();
            tree.init(new InputSource(this.getContext().getRealPath(this.resourceId)));
            return tree;
        }
        catch (Exception e) {
            throw new UniFormTransformationException("ServletResource: Can not create WellFormedUniFormTree (XML) Reason: " + e);
        }
    }

    public void save(XMLWellFormedData tree) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.getContext().getRealPath(this.resourceId));
        byte[] b = tree.getAsByteArray();
        fos.write(b, 0, b.length);
        fos.flush();
        fos.close();
    }

    public void create(XMLWellFormedData initTree) throws IOException {
        File res = new File(this.getContext().getRealPath(this.resourceId));
        if (!res.createNewFile()) {
            throw new IOException(" Resource '" + this.context.getResource(this.resourceId).toString() + "' already exists.");
        }
    }

    public void drop() throws IOException {
        File res = new File(this.getContext().getRealPath(this.resourceId));
        if (!res.delete()) {
            throw new IOException(" Resource '" + this.context.getResource(this.resourceId).toString() + "' can not be deleted.");
        }
    }

    private ServletContext getContext() throws IOException {
        if (this.context == null) {
            throw new IOException("ServletContext in ServletResource '" + this.resourceId + "' IS NULL!");
        }
        return this.context;
    }
}

