/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.resource.plugins;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import org.exoplatform.services.xml.querying.UniFormTransformationException;
import org.exoplatform.services.xml.querying.XMLWellFormedData;
import org.exoplatform.services.xml.querying.impl.xtas.WellFormedUniFormTree;
import org.exoplatform.services.xml.querying.impl.xtas.resource.Resource;
import org.xml.sax.InputSource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.modules.XMLResource;

public class XMLDBResource
extends Resource {
    private Database context = null;
    private String xmldbCollectionId = null;
    private String xmldbResourceId = null;

    public XMLDBResource(String resourceId) throws MalformedURLException {
        this();
        this.resourceId = resourceId;
    }

    public XMLDBResource() throws MalformedURLException {
        int resIndex = this.resourceId.indexOf("#") + 1;
        if (resIndex <= 0) {
            throw new MalformedURLException("Could not create XMLDBResource. Indefinite XML:DB resource-id (#resourceId) in'" + this.resourceId + "'");
        }
        this.xmldbResourceId = this.resourceId.substring(resIndex);
        this.xmldbCollectionId = this.resourceId.substring(0, resIndex - 1);
    }

    public void setContext(Object context) {
        if (!(context instanceof Database)) {
            throw new ClassCastException("XmlDbResource.setContext():" + context.getClass().getName() + " not subclass of org.xmldb.api.base.Database!");
        }
        this.context = (Database)context;
    }

    public XMLWellFormedData load() throws UniFormTransformationException, IOException {
        try {
            Collection col = DatabaseManager.getCollection((String)this.xmldbCollectionId);
            XMLResource res = (XMLResource)col.getResource(this.xmldbResourceId);
            if (res == null) {
                throw new Exception("XMLDB:XMLResource <" + this.xmldbResourceId + "> not found");
            }
            String content = (String)res.getContent();
            WellFormedUniFormTree tree = new WellFormedUniFormTree();
            tree.init(new InputSource(new ByteArrayInputStream(content.getBytes())));
            return tree;
        }
        catch (Exception e) {
            throw new UniFormTransformationException("XmldbResource: Can not create WellFormedUniFormTree (XML) Reason: " + e);
        }
    }

    public void save(XMLWellFormedData tree) throws IOException {
        try {
            Collection col = DatabaseManager.getCollection((String)this.xmldbCollectionId);
            String content = tree.getAsString();
            XMLResource res = (XMLResource)col.getResource(this.xmldbResourceId);
            if (res == null) {
                throw new Exception("XMLDB:XMLResource <" + this.xmldbResourceId + "> not found!");
            }
            res.setContent((Object)content);
            col.storeResource((org.xmldb.api.base.Resource)res);
        }
        catch (Exception e) {
            throw new IOException("XmldbResource: Can not save WellFormedUniFormTree (XML) Reason: " + e);
        }
    }

    public void create(XMLWellFormedData initTree) throws IOException {
        try {
            Collection col = DatabaseManager.getCollection((String)this.xmldbCollectionId);
            if ((XMLResource)col.getResource(this.xmldbResourceId) != null) {
                throw new Exception("XMLDB:XMLResource <" + this.xmldbResourceId + "> already exist!");
            }
            XMLResource res = (XMLResource)col.createResource(this.xmldbResourceId, "XMLResource");
            res.setContent((Object)"<null/>");
            col.storeResource((org.xmldb.api.base.Resource)res);
        }
        catch (Exception e) {
            throw new IOException("XmldbResource: Can not create Resource:" + this.resourceId + " Reason: " + e);
        }
    }

    public void drop() throws IOException {
        try {
            Collection col = DatabaseManager.getCollection((String)this.xmldbCollectionId);
            Resource res = (Resource)col.getResource(this.xmldbResourceId);
            if (res == null) {
                throw new Exception("XMLDB:XMLResource <" + this.xmldbResourceId + "> not found!");
            }
            col.removeResource(col.getResource(this.xmldbResourceId));
        }
        catch (Exception e) {
            throw new IOException("XmldbResource: Can not drop Resource:" + this.resourceId + " Reason: " + e);
        }
    }
}

