/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.querying.impl.xtas.xml;

import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class DtdTracer
implements LexicalHandler,
DeclHandler {
    private String name = null;
    private String publicId = null;
    private String systemId = null;
    private String text = "";
    private boolean isInternal = false;

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.name = name;
        this.systemId = systemId;
        this.publicId = publicId;
        if (systemId == null) {
            this.isInternal = true;
        } else {
            this.isInternal = false;
            this.text = "<!DOCTYPE " + name + " SYSTEM \"" + systemId + "\">";
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int offset, int length) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void endDTD() throws SAXException {
        if (this.isInternal) {
            this.text = this.text + "]>";
        }
    }

    public void elementDecl(String name, String contentModel) throws SAXException {
        if (this.isInternal) {
            this.text = this.text + "<!ELEMENT " + name + "(" + contentModel + ")>\n";
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String valueDefault, String value) throws SAXException {
        if (this.isInternal) {
            this.text = this.text + "<!ATTLIST " + elementName + " " + attributeName + " " + type + " " + valueDefault + " " + value + ">\n";
        }
    }

    public void internalEntityDecl(String name, String text) throws SAXException {
        if (this.isInternal) {
            text = text + "<!ENTITY " + name + "\"" + text + "\">\n";
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        String systemStr;
        String publicStr = publicId == null ? "" : " PUBLIC \"" + publicId + "\"";
        String string = systemStr = systemId == null ? "" : " SYSTEM \"" + systemId + "\"";
        if (this.isInternal) {
            this.text = this.text + "<!ENTITY " + name + "\"" + name + "\">" + systemStr + publicStr + "\n";
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getText() {
        return this.text;
    }
}

