/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.resolving.impl.simple;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.LogService;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SimpleResolver
implements EntityResolver {
    private String localPath;
    private Log log;

    public SimpleResolver(String localPath) {
        this.localPath = localPath;
        LogService logService = (LogService)ExoContainerContext.getTopContainer().getComponentInstanceOfType(LogService.class);
        this.log = logService.getLog(this.getClass());
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        this.log.debug((Object)("query for resolve entity publicId[" + publicId + " systemId[" + systemId + "]"));
        int fileIndex = systemId.lastIndexOf(47);
        if (fileIndex == -1) {
            return null;
        }
        String dtdPath = this.localPath + systemId.substring(fileIndex);
        this.log.debug((Object)("local path is [" + dtdPath + "]"));
        if (this.getClass().getResource(dtdPath) == null) {
            this.log.warn((Object)("Local entity definitions of '" + dtdPath + " not found in catalog. Trying to load from " + systemId + ".."));
            return null;
        }
        InputSource source = new InputSource(this.getClass().getResourceAsStream(dtdPath));
        this.log.debug((Object)("Local entity definitions found in '" + dtdPath + "'"));
        source.setSystemId(systemId);
        return source;
    }
}

