/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.resolving.impl.xmlcommons;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.exoplatform.services.xml.resolving.XMLCatalogResolvingService;
import org.xml.sax.EntityResolver;

public class XMLCommonsResolvingServiceImpl
implements XMLCatalogResolvingService {
    private CatalogResolver resolver = new CatalogResolver();

    public XMLCommonsResolvingServiceImpl() {
        String catalogs = System.getProperty("xml.catalog.files");
        if (catalogs == null) {
            Vector catalogFiles = new CatalogManager().getCatalogFiles();
            String files = "";
            for (int count = 0; count < catalogFiles.size(); ++count) {
                String file = (String)catalogFiles.elementAt(count);
                if (files != "") {
                    files = files + ";";
                }
                files = files + file;
            }
            System.setProperty("xml.catalog.files", files);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public boolean isLocallyResolvable(String publicId) {
        Catalog catalog = this.resolver.getCatalog();
        String result = null;
        try {
            result = catalog.resolveDoctype(null, publicId, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result != null;
    }

    public void addCatalog(String path) throws IOException {
        if (!new File(path).exists()) {
            throw new IOException("XmlCommonsResolvingServiceImpl.addCatalog( " + path + ") failed! Reason: file not found.");
        }
        String catalogs = System.getProperty("xml.catalog.files");
        catalogs = catalogs == null ? path : catalogs + ";" + path;
        System.setProperty("xml.catalog.files", path);
    }
}

