/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl.trax;

import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.impl.TransformerBase;
import org.exoplatform.services.xml.transform.trax.TRAXTransformer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TRAXTransformerImpl
extends TransformerBase
implements TRAXTransformer {
    protected TransformerHandler tHandler;

    protected Transformer getTransformer() {
        return this.tHandler.getTransformer();
    }

    public TRAXTransformerImpl() throws TransformerConfigurationException {
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.tHandler = saxTFactory.newTransformerHandler();
    }

    public TRAXTransformerImpl(Source source) throws TransformerConfigurationException {
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.tHandler = saxTFactory.newTransformerHandler(source);
    }

    public TRAXTransformerImpl(Templates templates) throws TransformerConfigurationException {
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.tHandler = saxTFactory.newTransformerHandler(templates);
    }

    protected void internalTransform(Source src) throws TransformerException, NotSupportedIOTypeException, IllegalStateException {
        XMLReader xmlReader = null;
        try {
            xmlReader = TRAXTransformerImpl.getXMLReader();
            if (this.resolvingService != null) {
                xmlReader.setEntityResolver(this.resolvingService.getEntityResolver());
                this.log.debug((Object)"Set entity resolver");
            }
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        xmlReader.setContentHandler(this.tHandler);
        InputSource inputSource = SAXSource.sourceToInputSource(src);
        try {
            xmlReader.parse(inputSource);
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        catch (IOException ex) {
            throw new TransformerException(ex);
        }
    }

    protected void afterInitResult() {
        this.tHandler.setResult(this.getResult());
    }

    public Result getTransformerAsResult() {
        return new SAXResult(this.tHandler);
    }

    public Object getParameter(String param) {
        return this.getTransformer().getParameter(param);
    }

    public void setParameter(String name, Object value) {
        this.getTransformer().setParameter(name, value);
    }

    public void clearParameters() {
        this.getTransformer().clearParameters();
    }

    public String getOutputProperty(String prop) {
        return this.getTransformer().getOutputProperty(prop);
    }

    public void setOutputProperty(String name, String value) {
        this.getTransformer().setOutputProperty(name, value);
    }

    public void setOutputProperties(Properties props) {
        this.getTransformer().setOutputProperties(props);
    }

    public Properties getOutputProperties() {
        return this.getTransformer().getOutputProperties();
    }

    public URIResolver getURIResolver() {
        return this.getTransformer().getURIResolver();
    }

    public void setURIResolver(URIResolver resolver) {
        this.getTransformer().setURIResolver(resolver);
    }

    public ErrorListener getErrorListener() {
        return this.getTransformer().getErrorListener();
    }

    public void setErrorListener(ErrorListener listener) {
        this.getTransformer().setErrorListener(listener);
    }
}

