/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl.trax;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import org.exoplatform.services.xml.resolving.XMLResolvingService;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.impl.trax.TRAXTemplatesImpl;
import org.exoplatform.services.xml.transform.impl.trax.TRAXTransformerImpl;
import org.exoplatform.services.xml.transform.trax.TRAXTemplates;
import org.exoplatform.services.xml.transform.trax.TRAXTransformer;
import org.exoplatform.services.xml.transform.trax.TRAXTransformerService;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TRAXTransformerServiceImpl
implements TRAXTransformerService {
    private XMLResolvingService resolvingService;

    public TRAXTransformerServiceImpl(XMLResolvingService resolvingService) {
        this.resolvingService = resolvingService;
    }

    public TRAXTransformer getTransformer() throws TransformerConfigurationException {
        TRAXTransformerImpl transf = new TRAXTransformerImpl();
        transf.resolvingService = this.resolvingService;
        return transf;
    }

    public TRAXTransformer getTransformer(Source source) throws TransformerConfigurationException {
        TRAXTransformerImpl transf = new TRAXTransformerImpl(source);
        transf.resolvingService = this.resolvingService;
        return transf;
    }

    public TRAXTemplates getTemplates(Source source) throws TransformerException, NotSupportedIOTypeException {
        TRAXTemplatesImpl templates = new TRAXTemplatesImpl(this.getXSLTemplates(source));
        templates.resolvingService = this.resolvingService;
        return templates;
    }

    private Templates getXSLTemplates(Source source) throws TransformerException, NotSupportedIOTypeException {
        XMLReader xmlReader;
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TemplatesHandler templateHandler = saxTFactory.newTemplatesHandler();
        try {
            xmlReader = TRAXTransformerImpl.getXMLReader();
            if (this.resolvingService != null) {
                xmlReader.setEntityResolver(this.resolvingService.getEntityResolver());
            }
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        xmlReader.setContentHandler(templateHandler);
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        if (inputSource == null) {
            throw new NotSupportedIOTypeException(source);
        }
        try {
            xmlReader.parse(inputSource);
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        catch (IOException ex) {
            throw new TransformerException(ex);
        }
        return templateHandler.getTemplates();
    }
}

