/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core;

import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.client.http.HttpClientInfo;
import org.exoplatform.faces.context.PortletExternalContext;
import org.exoplatform.faces.core.component.InformationProvider;
import org.exoplatform.portal.Information;
import org.exoplatform.portal.session.ExoPortal;
import org.exoplatform.portal.session.PortalResources;

public class Util {
    public static Renderer getRenderer(FacesContext context, String type, String family) {
        if (type != null) {
            HttpClientInfo info = (HttpClientInfo)SessionContainer.getInstance().getClientInfo();
            if ("mobile-browser".equals(info.getPreferredMimeType())) {
                return Util.getXHTMLMPRenderer(context, type, family);
            }
            return Util.getXHTMLRenderer(context, type, family);
        }
        return null;
    }

    public static Renderer getXHTMLMPRenderer(FacesContext context, String type, String family) {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkFactory.getRenderKit(null, "xhtmlmp");
        Renderer renderer = renderKit.getRenderer(family, type);
        if (renderer == null) {
            renderer = Util.getXHTMLRenderer(context, type, family);
        }
        return renderer;
    }

    public static Renderer getXHTMLRenderer(FacesContext context, String type, String family) {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        return renderKit.getRenderer(family, type);
    }

    public static ResourceBundle getApplicationResourceBundle() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof PortletExternalContext) {
            PortletExternalContext econtext = (PortletExternalContext)externalContext;
            return econtext.getApplicationResourceBundle();
        }
        PortalResources appres = (PortalResources)SessionContainer.getComponent(PortalResources.class);
        return appres.getApplicationResource();
    }

    public static Information findInformationProvider(UIComponent src) {
        InformationProvider provider = null;
        while (provider == null) {
            if (src instanceof InformationProvider) {
                provider = (InformationProvider)src;
                continue;
            }
            if (src instanceof UIViewRoot) {
                ExoPortal portal = (ExoPortal)SessionContainer.getComponent(ExoPortal.class);
                return portal.getInformation();
            }
            src = src.getParent();
        }
        return provider.getInformation();
    }

    public static PhaseId getActionPhaseId(String action) {
        if (action.startsWith("PhaseId[1].")) {
            return PhaseId.APPLY_REQUEST_VALUES;
        }
        return PhaseId.INVOKE_APPLICATION;
    }

    public static String encodeActionPhase(String action, PhaseId phaseId) {
        if (PhaseId.APPLY_REQUEST_VALUES == phaseId) {
            action = "PhaseId[1]." + action;
        }
        return action;
    }

    public static String getRemoteUser() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        return econtext.getRemoteUser();
    }

    public static boolean hasRole(String role) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        return econtext.isUserInRole(role);
    }
}

