/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UIStringInput;

public class UICalendarInput
extends UIStringInput {
    private boolean displayTime;
    protected GregorianCalendar calendar_;
    private SimpleDateFormat sdf_ = new SimpleDateFormat("dd/MM/yyyy");

    public UICalendarInput(String name, String text) {
        super(name, text);
        if (this.displayTime) {
            this.sdf_ = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        }
        Date date = new Date();
        if (text != null && !text.equals("")) {
            this.calendar_ = new GregorianCalendar();
            try {
                date = this.sdf_.parse(text);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.calendar_.setTime(date);
        }
        this.setRendererType("CalendarInputRenderer");
    }

    public Object getDecodedValue() {
        try {
            Date d = this.calendar_.getTime();
            if (this.displayTime) {
                this.sdf_ = new SimpleDateFormat("dd/MM/yyyy hh:mm");
            }
            return this.sdf_.format(d);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getValue() {
        if (this.calendar_ != null) {
            return ISO8601.format((Calendar)this.calendar_);
        }
        return ISO8601.format((Calendar)new GregorianCalendar());
    }

    public UIInput setValue(String value) {
        if (this.calendar_ == null) {
            this.calendar_ = new GregorianCalendar();
        }
        this.calendar_.setTime(ISO8601.parse((String)value).getTime());
        return this;
    }

    public Calendar getCalendar() {
        return this.calendar_;
    }

    public UICalendarInput addTime(Date date) {
        if (date != null) {
            this.calendar_.setTime(date);
        } else {
            this.calendar_ = null;
        }
        return this;
    }

    public boolean isDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(boolean displayTime) {
        this.displayTime = displayTime;
    }

    public void decodeFromMultipartFields(FacesContext context, UIComponent component, List items) {
        Iterator iter = items.iterator();
        String choosenDate = "";
        while (iter.hasNext()) {
            String name;
            FileItem item = (FileItem)iter.next();
            if (!item.isFormField() || (name = item.getFieldName()) == null || !name.equalsIgnoreCase(this.getName())) continue;
            choosenDate = item.getString();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        if (this.displayTime) {
            sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        }
        Date date = null;
        if (choosenDate != null && !choosenDate.trim().equals("")) {
            this.calendar_ = new GregorianCalendar();
            try {
                date = sdf.parse(choosenDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.addTime(date);
        } else if (choosenDate != null && choosenDate.trim().equals("")) {
            this.addTime(date);
        }
    }

    public void setProperty(String propertyName, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap(3);
        }
        this.properties.put(propertyName, value);
    }
}

