/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.faces.core.component.UIInput;

public class UIDateInput
extends UIInput {
    public static final int TEXT = 0;
    public static final int PASSWORD = 1;
    public static final String DAY_EXTENSION = "_dd";
    public static final String MONTH_EXTENSION = "_mm";
    public static final String YEAR_EXTENSION = "_yyyy";
    protected GregorianCalendar calendar_;
    private int minYearRange_ = 2000;
    private int maxYearRange_ = 2010;

    public UIDateInput(String name, Date date) {
        this.setId(name);
        this.name_ = name;
        this.calendar_ = new GregorianCalendar();
        this.calendar_.set(11, 23);
        this.calendar_.set(12, 59);
        this.maxYearRange_ = this.calendar_.get(1);
        this.calendar_.setTime(date);
        this.editable_ = true;
        this.setRendererType("DateInputRenderer");
    }

    public String getFamily() {
        return "org.exoplatform.faces.core.component.UIExoComponent";
    }

    public Object getDecodedValue() {
        return this.calendar_.getTime();
    }

    public Calendar getCalendar() {
        return this.calendar_;
    }

    public int getMinYearRange() {
        return this.minYearRange_;
    }

    public void setMinYearRange(int year) {
        this.minYearRange_ = year;
    }

    public int getMaxYearRange() {
        return this.maxYearRange_;
    }

    public void setMaxYearRange(int year) {
        this.maxYearRange_ = year;
    }

    public UIDateInput addValidator(Validator validator) {
        this.addComponentValidator(validator);
        return this;
    }

    public UIDateInput addValidator(Class clazz) {
        this.addComponentValidator(clazz);
        return this;
    }

    public UIDateInput addDate(Date date) {
        this.calendar_.setTime(date);
        return this;
    }

    public final void processValidators(FacesContext context) {
        this.processValidators(context, this.calendar_);
    }

    public void decodeFromMultipartFields(FacesContext context, UIComponent component, List items) {
        String dayValue = "";
        String monthValue = "";
        String yearValue = "";
        for (FileItem item : items) {
            if (!item.isFormField()) continue;
            String name = item.getFieldName();
            if (name.equals(this.getName() + DAY_EXTENSION)) {
                dayValue = item.getString();
                continue;
            }
            if (name.equals(this.getName() + MONTH_EXTENSION)) {
                monthValue = item.getString();
                continue;
            }
            if (!name.equals(this.getName() + YEAR_EXTENSION)) continue;
            yearValue = item.getString();
        }
        try {
            Calendar cal = this.getCalendar();
            cal.set(5, Integer.parseInt(dayValue));
            cal.set(2, Integer.parseInt(monthValue));
            cal.set(1, Integer.parseInt(yearValue));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }
}

