/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.faces.core.component.UIInput;

public class UIDateTimeInput
extends UIInput {
    public static final String COMPONENT_FAMILY = "org.exoplatform.faces.core.component.UIDateTimeInput";
    public static final String DAY_EXTENSION = "_dd";
    public static final String MONTH_EXTENSION = "_mm";
    public static final String YEAR_EXTENSION = "_yyyy";
    public static final String HOUR_EXTENSION = "_hh";
    public static final String MINUTE_EXTENSION = "_min";
    protected GregorianCalendar calendar_;
    private int minuteStep_;
    private boolean updateOnChangeAction_;
    private int minYearRange_ = GregorianCalendar.getInstance().get(1) - 5;
    private int maxYearRange_ = GregorianCalendar.getInstance().get(1) + 5;

    public UIDateTimeInput(String name, Date date) {
        this.setId(name);
        this.name_ = name;
        this.calendar_ = new GregorianCalendar();
        this.calendar_.setTime(date);
        this.minuteStep_ = 1;
        this.editable_ = true;
        this.setRendererType("DateTimeInputRenderer");
    }

    public UIDateTimeInput(String name, Date date, int minuteStep) {
        this(name, date);
        this.minuteStep_ = minuteStep;
    }

    public UIDateTimeInput setUpdateOnChangeAction(boolean b) {
        this.updateOnChangeAction_ = b;
        return this;
    }

    public boolean getUpdateOnChangeAction() {
        return this.updateOnChangeAction_;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Object getDecodedValue() {
        return this.calendar_.getTime();
    }

    public String getValue() {
        return ISO8601.format((Calendar)this.calendar_);
    }

    public Calendar getCalendar() {
        return this.calendar_;
    }

    public UIDateTimeInput addValidator(Validator validator) {
        this.addComponentValidator(validator);
        return this;
    }

    public UIDateTimeInput addValidator(Class clazz) {
        this.addComponentValidator(clazz);
        return this;
    }

    public UIDateTimeInput addTime(Date date) {
        this.calendar_.setTime(date);
        if (this.calendar_.get(1) < this.minYearRange_ || this.calendar_.get(1) > this.maxYearRange_) {
            this.minYearRange_ = GregorianCalendar.getInstance().get(1) - 5;
            this.maxYearRange_ = GregorianCalendar.getInstance().get(1) + 5;
        }
        return this;
    }

    public int getMinYearRange() {
        return this.minYearRange_;
    }

    public void setMinYearRange(int year) {
        if (year > this.maxYearRange_) {
            return;
        }
        if (this.calendar_.get(1) < year) {
            return;
        }
        this.minYearRange_ = year;
    }

    public int getMaxYearRange() {
        return this.maxYearRange_;
    }

    public void setMaxYearRange(int year) {
        if (year < this.minYearRange_) {
            return;
        }
        if (this.calendar_.get(1) > year) {
            return;
        }
        this.maxYearRange_ = year;
    }

    public void setMinuteStep_(int minuteStep) {
        this.minuteStep_ = minuteStep;
    }

    public int getMinuteStep_() {
        return this.minuteStep_;
    }

    public final void processValidators(FacesContext context) {
        this.processValidators(context, this.calendar_);
    }

    public void decodeFromMultipartFields(FacesContext context, UIComponent component, List items) {
        int dayValue = 0;
        int monthValue = 0;
        int yearValue = 0;
        int hourValue = 0;
        int minuteValue = 0;
        for (FileItem item : items) {
            if (!item.isFormField()) continue;
            String name = item.getFieldName();
            if (name.equals(this.getName() + DAY_EXTENSION)) {
                dayValue = Integer.parseInt(item.getString());
                continue;
            }
            if (name.equals(this.getName() + MONTH_EXTENSION)) {
                monthValue = Integer.parseInt(item.getString());
                continue;
            }
            if (name.equals(this.getName() + YEAR_EXTENSION)) {
                yearValue = Integer.parseInt(item.getString());
                continue;
            }
            if (name.equals(this.getName() + HOUR_EXTENSION)) {
                hourValue = Integer.parseInt(item.getString());
                continue;
            }
            if (!name.equals(this.getName() + MINUTE_EXTENSION)) continue;
            minuteValue = Integer.parseInt(item.getString());
        }
        GregorianCalendar gCal = new GregorianCalendar(yearValue, monthValue, dayValue, hourValue, minuteValue, 0);
        this.addTime(gCal.getTime());
    }
}

