/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.faces.ActionListenerManager;
import org.exoplatform.faces.UIComponentFactory;
import org.exoplatform.faces.context.PortletExternalContext;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.component.ComponentUtil;
import org.exoplatform.faces.core.component.UIExoComponent;
import org.exoplatform.faces.core.event.ExoActionEvent;
import org.exoplatform.faces.core.event.ExoActionListener;
import org.exoplatform.portal.session.RequestInfo;

public class UIExoCommand
extends UICommand
implements UIExoComponent {
    protected String baseURL_;
    protected String crossURL_;
    private String clazz_;
    private transient Renderer cacheRenderer_;

    public String getClazz() {
        return this.clazz_;
    }

    public UIExoComponent setClazz(String clazz) {
        this.clazz_ = clazz;
        return this;
    }

    public String getFamily() {
        return "org.exoplatform.faces.core.component.UIExoComponent";
    }

    public boolean canDecodeInvalidState() {
        return true;
    }

    public void decode(FacesContext context) {
        String action;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String uicomponent = (String)paramMap.get("uicomponent");
        if (uicomponent != null && uicomponent.equals(this.getId()) && (action = (String)paramMap.get("op")) != null) {
            this.broadcast((FacesEvent)new ExoActionEvent((UIComponent)this, action, paramMap));
        }
    }

    public void processDecodes(FacesContext context) {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (!child.isRendered()) continue;
            child.processDecodes(context);
            if (!context.getRenderResponse()) continue;
            return;
        }
        this.decode(context);
    }

    public void setId(String id) {
        super.setId(id);
        this.baseURL_ = null;
        this.crossURL_ = null;
    }

    public void setRendererType(String type) {
        this.cacheRenderer_ = null;
        super.setRendererType(type);
    }

    public Renderer getRenderer(FacesContext context) {
        if (this.cacheRenderer_ == null) {
            this.cacheRenderer_ = Util.getRenderer(context, this.getRendererType(), this.getFamily());
        }
        return this.cacheRenderer_;
    }

    public UIExoComponent findComponentById(String id) {
        return ComponentUtil.findComponentById(this, id);
    }

    public UIExoComponent findRenderedComponentById(String id) {
        return ComponentUtil.findRenderedComponentById(this, id);
    }

    public Object getChildComponentOfType(Class classType) {
        return ComponentUtil.getChildComponentOfType((UIComponent)this, classType);
    }

    public UIComponent getAncestorOfType(Class classType) {
        return ComponentUtil.getAncestorOfType((UIComponent)this, classType);
    }

    public void setRenderedComponent(String id) {
        ComponentUtil.setRenderedComponent((UIExoComponent)this, id);
    }

    public void setRenderedComponent(Class type) {
        ComponentUtil.setRenderedComponent((UIExoComponent)this, type);
    }

    public void setRenderedSibling(Class type) {
        ComponentUtil.setRenderedSibling(this, type);
    }

    public UIComponent getSibling(Class type) {
        return ComponentUtil.getSibling((UIComponent)this, type);
    }

    public List findDescendantsOfType(Class type) {
        return ComponentUtil.findDescendantsOfType((UIComponent)this, type);
    }

    public UIComponent findDescendantOfType(Class type) {
        return ComponentUtil.findDescendantOfType((UIComponent)this, type);
    }

    public String getBaseURL(FacesContext context) {
        if (this.baseURL_ == null) {
            ExternalContext econtext = context.getExternalContext();
            if (econtext instanceof PortletExternalContext) {
                this.baseURL_ = econtext.encodeActionURL("");
                this.baseURL_ = this.baseURL_ + "&amp;uicomponent=" + this.getId();
            } else {
                RequestInfo rinfo = (RequestInfo)SessionContainer.getComponent(RequestInfo.class);
                this.baseURL_ = rinfo.getOwnerURI();
                this.baseURL_ = this.baseURL_ + "?uicomponent=" + this.getId();
            }
        }
        return this.baseURL_;
    }

    public String getBaseURL() {
        if (this.baseURL_ != null) {
            return this.baseURL_;
        }
        return this.getBaseURL(FacesContext.getCurrentInstance());
    }

    public String getCrossURL(FacesContext context, String component, String page) {
        if (this.crossURL_ == null) {
            ExternalContext econtext = context.getExternalContext();
            if (econtext instanceof PortletExternalContext) {
                RequestInfo rinfo = (RequestInfo)SessionContainer.getComponent(RequestInfo.class);
                this.crossURL_ = rinfo.getOwnerURI();
                this.crossURL_ = page != null && !page.trim().equals("") ? this.crossURL_ + page : this.crossURL_ + rinfo.getNodeURI();
                this.crossURL_ = this.crossURL_ + "?";
                this.crossURL_ = this.crossURL_ + "portal:componentId=" + component;
                this.crossURL_ = this.crossURL_ + "&amp;portal:type=action";
                this.crossURL_ = this.crossURL_ + "&amp;portal:isSecure=false";
                this.crossURL_ = this.crossURL_ + "&amp;uicomponent=" + this.getId();
            } else {
                RequestInfo rinfo = (RequestInfo)SessionContainer.getComponent(RequestInfo.class);
                this.crossURL_ = rinfo.getOwnerURI();
                this.crossURL_ = this.crossURL_ + "?uicomponent=" + this.getId();
            }
        }
        return this.crossURL_;
    }

    public String getCrossURL(String component, String page) {
        if (component == null || component.equals("")) {
            return this.getBaseURL();
        }
        if (this.crossURL_ != null) {
            return this.crossURL_;
        }
        return this.getCrossURL(FacesContext.getCurrentInstance(), component, page);
    }

    public static String getRemoteUser() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        return econtext.getRemoteUser();
    }

    protected boolean hasOwnerRole(String user) {
        if (user == null) {
            return false;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        return user.equals(econtext.getRemoteUser());
    }

    protected boolean hasRole(String role) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        return econtext.isUserInRole(role);
    }

    public void addActionListener(Class clazz, String actionToListen) {
        PortalContainer pcontainer = PortalContainer.getInstance();
        ActionListenerManager manager = (ActionListenerManager)pcontainer.getComponentInstanceOfType(ActionListenerManager.class);
        ExoActionListener result = manager.getActionListener(clazz, actionToListen);
        this.addActionListener(result);
    }

    public void removeTransientActionListenerInterceptors() {
        ActionListener[] actionListeners;
        for (ActionListener actionListener : actionListeners = this.getActionListeners()) {
            if (!(actionListener instanceof ExoActionListener)) continue;
            ExoActionListener exoActionListener = (ExoActionListener)actionListener;
            exoActionListener.removeTransientInterceptors();
        }
    }

    public boolean hasChild(Class cl) {
        return this.getChildComponentOfType(cl) != null;
    }

    public UIExoComponent addChild(Class cl) throws Exception {
        UIExoComponent uiComponent = UIComponentFactory.createComponent(cl);
        this.getChildren().add(uiComponent);
        uiComponent.registerActionListener(this);
        uiComponent.registerComponentObserver(this);
        return uiComponent;
    }

    public void registerActionListener(UIExoComponent parent) {
    }

    public void registerComponentObserver(UIExoComponent parent) {
    }
}

