/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.exoplatform.faces.core.component.UIExoCommand;
import org.exoplatform.faces.core.event.ExoActionEvent;

public class UIFileUpload
extends UIExoCommand {
    public static final String UPLOAD_ACTION = "upload";
    public static final String CANCEL_ACTION = "cancel";
    private int numberOfField_;
    private String userAction_;
    private HashMap userInputs_;
    private String parentUri_;
    private boolean showCancel_ = true;
    private boolean showHeader_ = true;

    public UIFileUpload() {
        this.setRendererType("FileUploadRenderer");
        this.setId("UIFileUpload");
        this.numberOfField_ = 3;
        this.userInputs_ = new HashMap();
    }

    public void decode(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String uicomponent = (String)paramMap.get("uicomponent");
        if (!this.getId().equals(uicomponent)) {
            return;
        }
        PortletRequest request = (PortletRequest)context.getExternalContext().getRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        this.userInputs_.clear();
        try {
            if (FileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
                DiskFileUpload upload = new DiskFileUpload();
                List items = upload.parseRequest(httpRequest);
                for (FileItem item : items) {
                    if (item.isFormField()) continue;
                    String fileField = item.getFieldName();
                    String fileName = item.getName();
                    byte[] buf = item.get();
                    if (buf == null || buf.length <= 0) continue;
                    this.userInputs_.put(fileField, new UserInput(null, fileName, buf));
                }
                for (FileItem item : items) {
                    if (!item.isFormField()) continue;
                    String name = item.getFieldName();
                    if ("op".equals(name)) {
                        this.userAction_ = item.getString();
                        continue;
                    }
                    String value = item.getString();
                    int index = name.lastIndexOf("-");
                    String number = name.substring(index + 1, name.length());
                    String fileField = "file-" + number;
                    UserInput input = (UserInput)this.userInputs_.get(fileField);
                    if (input == null) continue;
                    input.setName(value);
                }
            } else {
                this.userAction_ = CANCEL_ACTION;
            }
            this.broadcast((FacesEvent)new ExoActionEvent((UIComponent)this, this.userAction_));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getNumberOfField() {
        return this.numberOfField_;
    }

    public void setNumberOfField(int numberOfField) {
        this.numberOfField_ = numberOfField;
    }

    public String getUserAction() {
        return this.userAction_;
    }

    public String getParentUri() {
        return this.parentUri_;
    }

    public void setParentUri(String uri) {
        this.parentUri_ = uri;
    }

    public Collection getUserInputs() {
        return this.userInputs_.values();
    }

    public boolean isShowCancel() {
        return this.showCancel_;
    }

    public void setShowCancel(boolean b) {
        this.showCancel_ = b;
    }

    public boolean isShowHeader() {
        return this.showHeader_;
    }

    public void setShowHeader(boolean b) {
        this.showHeader_ = b;
    }

    public class UserInput {
        String fileName_;
        String name_;
        byte[] buf_;

        public UserInput(String name, String fileName, byte[] buf) {
            this.name_ = name;
            this.fileName_ = fileName;
            this.buf_ = buf;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public String getFileName() {
            return this.fileName_;
        }

        public void setFileName(String name) {
            this.fileName_ = name;
        }

        public byte[] getStream() {
            return this.buf_;
        }

        public void setStream(byte[] buf) {
            this.buf_ = buf;
        }
    }
}

