/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.validator.Validator;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.model.SelectItem;

public class UIRadioBox
extends UIInput {
    public static int VERTICAL_ALIGN = 1;
    public static int HORIZONTAL_ALIGN = 2;
    private List options_;
    private int align_;

    public UIRadioBox(String name, String value) {
        this.name_ = name;
        this.value_ = value;
        this.align_ = HORIZONTAL_ALIGN;
    }

    public UIRadioBox(String name, String value, List options) {
        this.name_ = name;
        this.value_ = value;
        this.options_ = options;
        this.align_ = HORIZONTAL_ALIGN;
    }

    public final List getOptions() {
        return this.options_;
    }

    public final UIRadioBox setOptions(List options) {
        this.options_ = options;
        return this;
    }

    public final UIRadioBox setAlign(int val) {
        this.align_ = val;
        return this;
    }

    public UIRadioBox addValidator(Validator validator) {
        this.addComponentValidator(validator);
        return this;
    }

    public UIRadioBox addValidator(Class clazz) {
        this.addComponentValidator(clazz);
        return this;
    }

    public void decode(FacesContext context) {
        if (!this.editable_ || this.readonly_) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)paramMap.get(this.name_);
        if (value != null) {
            this.value_ = value;
        }
    }

    public void decodeFromMultipartFields(FacesContext context, UIComponent component, List items) {
        if (!this.editable_ || this.readonly_) {
            return;
        }
        for (FileItem item : items) {
            if (!item.isFormField()) continue;
            String name = item.getFieldName();
            String value = item.getString();
            if (!name.equals(this.getName()) || value == null) continue;
            this.value_ = this.decodeString(value);
        }
    }

    public final void processValidators(FacesContext context) {
        this.processValidators(context, this.value_);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        if (this.value_ == null) {
            SelectItem si = (SelectItem)this.options_.get(0);
            this.value_ = si.value_;
        }
        ResourceBundle res = Util.getApplicationResourceBundle();
        if (this.align_ == VERTICAL_ALIGN) {
            w.write("<div style='overflow:hidden; width: 100%'>");
        } else {
            w.write("<div>");
        }
        for (int i = 0; i < this.options_.size(); ++i) {
            SelectItem si = (SelectItem)this.options_.get(i);
            String checked = "";
            if (si.value_.equals(this.value_)) {
                checked = " checked";
            }
            if (this.align_ == VERTICAL_ALIGN) {
                w.write("<div style='float:left; margin-right:2px; vertical-align: middle;'>");
            }
            w.write("<input class='radio' type='radio'");
            if (!this.editable_ || this.readonly_) {
                w.write(" readonly='readonly'");
            }
            w.write(checked);
            w.write(" name='");
            w.write(this.name_);
            w.write("'");
            w.write(" value='");
            w.write(si.value_);
            w.write("'/>");
            w.write(ExpressionUtil.getExpressionValue((ResourceBundle)res, (String)si.display_));
            if (this.align_ != VERTICAL_ALIGN) continue;
            w.write("</div>");
        }
        w.write("</div>");
    }
}

