/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.component.model.SelectItem;

public class UISelectBox
extends UIInput {
    private String updateOnChangeAction_;
    private List options_;
    private int size_ = 1;
    private String defaultValue_;

    public UISelectBox(String name, String value, List options) {
        this.name_ = name;
        this.value_ = value;
        this.defaultValue_ = value;
        this.options_ = options;
    }

    public final UISelectBox setSize(int i) {
        this.size_ = i;
        return this;
    }

    public final String getUpdateOnChangeAction() {
        return this.updateOnChangeAction_;
    }

    public final UISelectBox setUpdateOnChangeAction(String s) {
        this.updateOnChangeAction_ = s;
        return this;
    }

    public final List getOptions() {
        return this.options_;
    }

    public final UISelectBox setOptions(List options) {
        this.options_ = options;
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    public void reset() {
        this.value_ = this.defaultValue_;
    }

    public void decode(FacesContext context) {
        if (!this.editable_ || this.readonly_) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)paramMap.get(this.name_);
        if (value != null) {
            this.value_ = value;
        }
    }

    public void decodeFromMultipartFields(FacesContext context, UIComponent component, List items) {
        for (FileItem item : items) {
            String name;
            if (!item.isFormField() || !(name = item.getFieldName()).equals(this.getName())) continue;
            this.value_ = this.decodeString(item.getString());
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        ResourceBundle res = Util.getApplicationResourceBundle();
        w.write("<select ");
        w.write("name='");
        w.write(this.name_);
        w.write("'");
        if (this.size_ > 1) {
            w.write(" multiple='true' size='" + this.size_ + "'");
        }
        if (!this.editable_ || this.readonly_) {
            w.write(" disabled='true'");
        }
        if (this.getClazz() != null) {
            w.write(" class='");
            w.write(this.getClazz());
            w.write("'");
        }
        if (this.updateOnChangeAction_ != null) {
            UISimpleForm uiForm = (UISimpleForm)this.getParent();
            String formName = uiForm.getFormName();
            w.write(" onchange=\"javascript:submitForm('");
            w.write(formName);
            w.write("','");
            w.write(this.updateOnChangeAction_);
            w.write("')\"");
        }
        w.write(">\n");
        for (int i = 0; i < this.options_.size(); ++i) {
            SelectItem si = (SelectItem)this.options_.get(i);
            if (si.value_.equals(this.value_)) {
                w.write("<option selected=\"selected\" value=\"");
                w.write(si.value_);
                w.write("\">");
                w.write(ExpressionUtil.getExpressionValue((ResourceBundle)res, (String)si.display_));
                w.write("</option>\n");
                continue;
            }
            w.write("<option value=\"");
            w.write(si.value_);
            w.write("\">");
            w.write(ExpressionUtil.getExpressionValue((ResourceBundle)res, (String)si.display_));
            w.write("</option>\n");
        }
        w.write("</select>\n");
    }
}

