/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.exoplatform.faces.core.component.UIExoComponentBase;
import org.exoplatform.faces.core.component.model.Button;
import org.exoplatform.faces.core.event.ExoActionEvent;

public class UIToolbar
extends UIExoComponentBase {
    public static final String COMPONENT_FAMILY = "org.exoplatform.faces.core.component.UIToolbar";
    public static final String BUTTON_PARAM = "button";
    private List leftButtons_;
    private List centerButtons_;
    private List rightButtons_;

    public UIToolbar() {
        this("UIToolbar");
    }

    public UIToolbar(String id) {
        this.setId(id);
        this.setRendererType("ToolbarRenderer");
    }

    public void addLeftButton(Button button) {
        if (this.leftButtons_ == null) {
            this.leftButtons_ = new ArrayList();
        }
        this.leftButtons_.add(button);
    }

    public void addCenterButton(Button button) {
        if (this.centerButtons_ == null) {
            this.centerButtons_ = new ArrayList();
        }
        this.centerButtons_.add(button);
    }

    public void addRightButton(Button button) {
        if (this.rightButtons_ == null) {
            this.rightButtons_ = new ArrayList();
        }
        this.rightButtons_.add(button);
    }

    public List getLeftButtons() {
        return this.leftButtons_;
    }

    public List getCenterButtons() {
        return this.centerButtons_;
    }

    public List getRightButtons() {
        return this.rightButtons_;
    }

    public boolean isRendered() {
        return true;
    }

    public void decode(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String comp = (String)paramMap.get("uicomponent");
        if (this.getId().equals(comp)) {
            UIComponent parent = this.getParent();
            try {
                String action = (String)paramMap.get("op");
                parent.broadcast((FacesEvent)new ExoActionEvent(parent, action, paramMap));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void processDecodes(FacesContext context) {
        this.decode(context);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }
}

