/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.event;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.event.ActionInterceptor;
import org.exoplatform.faces.core.event.ExceptionHandler;
import org.exoplatform.faces.core.event.ExoActionEvent;
import org.exoplatform.faces.core.event.FatalExceptionHandler;
import org.exoplatform.faces.core.event.MessageExceptionHandler;
import org.exoplatform.faces.core.event.PermissionExceptionHandler;
import org.exoplatform.faces.core.event.UniqueObjectExceptionHandler;
import org.exoplatform.portal.Information;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExoActionListener
implements ActionListener {
    private static List exceptionHandlers_ = new ArrayList(10);
    private List interceptors_;
    private String action_;

    public void init() {
    }

    public ExoActionListener setActionToListen(String action) {
        this.action_ = action;
        return this;
    }

    public String getActionName() {
        return this.action_;
    }

    public final void processAction(ActionEvent action) throws AbortProcessingException {
        throw new AbortProcessingException("Use processAction(ExoActionEvent action)");
    }

    public boolean canHandleAction(String action) {
        return this.action_.equals(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processAction(ExoActionEvent action) throws AbortProcessingException {
        block10: {
            ArrayList<ActionInterceptor> transientInterceptors = new ArrayList<ActionInterceptor>();
            try {
                ActionInterceptor interceptor;
                int i;
                if (this.interceptors_ != null) {
                    for (i = 0; i < this.interceptors_.size(); ++i) {
                        interceptor = (ActionInterceptor)this.interceptors_.get(i);
                        interceptor.preExecute(action);
                    }
                }
                this.execute(action);
                if (this.interceptors_ == null) break block10;
                for (i = 0; i < this.interceptors_.size(); ++i) {
                    interceptor = (ActionInterceptor)this.interceptors_.get(i);
                    interceptor.postExecute(action);
                    if (!interceptor.isTransient()) continue;
                    transientInterceptors.add(interceptor);
                }
            }
            catch (Exception ex) {
                ExceptionHandler handler = null;
                for (int i = 0; i < exceptionHandlers_.size(); ++i) {
                    ExceptionHandler eh = (ExceptionHandler)exceptionHandlers_.get(i);
                    if (!eh.canHandleError(ex)) continue;
                    handler = eh;
                    break;
                }
                handler.handle(action, ex);
            }
            finally {
                for (ActionInterceptor interceptor : transientInterceptors) {
                    this.interceptors_.remove(interceptor);
                }
            }
        }
        this.postExecute(action);
    }

    protected void postExecute(ExoActionEvent action) {
        FacesContext.getCurrentInstance().renderResponse();
    }

    public abstract void execute(ExoActionEvent var1) throws Exception;

    public ExoActionListener addInterceptor(ActionInterceptor interceptor) {
        if (this.interceptors_ == null) {
            this.interceptors_ = new ArrayList(3);
        }
        this.interceptors_.add(interceptor);
        return this;
    }

    public List<ActionInterceptor> getInterceptors() {
        return this.interceptors_;
    }

    protected Information findInformationProvider(UIComponent src) {
        return Util.findInformationProvider(src);
    }

    protected ResourceBundle getApplicationResourceBundle() {
        ResourceBundle res = Util.getApplicationResourceBundle();
        return res;
    }

    public void removeTransientInterceptors() {
        ArrayList<ActionInterceptor> transientInterceptors = new ArrayList<ActionInterceptor>();
        if (this.interceptors_ != null) {
            for (int i = 0; i < this.interceptors_.size(); ++i) {
                ActionInterceptor interceptor = (ActionInterceptor)this.interceptors_.get(i);
                if (!interceptor.isTransient()) continue;
                transientInterceptors.add(interceptor);
            }
        }
        for (ActionInterceptor interceptor : transientInterceptors) {
            this.interceptors_.remove(interceptor);
        }
    }

    static {
        exceptionHandlers_.add(new UniqueObjectExceptionHandler());
        exceptionHandlers_.add(new MessageExceptionHandler());
        exceptionHandlers_.add(new PermissionExceptionHandler());
        exceptionHandlers_.add(new FatalExceptionHandler());
    }
}

