/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.faces.core.component.UIFileUpload;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;

public class FileUploadRenderer
extends HtmlBasicRenderer {
    public final void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIFileUpload uicomp = (UIFileUpload)component;
        ExternalContext econtext = context.getExternalContext();
        ResourceBundle res = FileUploadRenderer.getApplicationResourceBundle(econtext);
        String uploadHeader = "Upload File";
        String fileLabel = "File";
        String nameLabel = "Name";
        try {
            uploadHeader = res.getString("UIFileUpload.header.upload-file-header");
            fileLabel = res.getString("UIFileUpload.label.file");
            nameLabel = res.getString("UIFileUpload.label.name");
        }
        catch (Exception ex) {
            // empty catch block
        }
        String baseUrl = uicomp.getBaseURL(context);
        ResponseWriter w = context.getResponseWriter();
        String clazz = uicomp.getClazz();
        if (clazz == null) {
            clazz = "";
        }
        w.write("<form id='uploadForm' name='uploadForm' action='" + baseUrl + "' method='post' enctype='multipart/form-data'");
        w.write(" class='UISimpleForm");
        if (clazz != null) {
            w.write(32);
            w.write(clazz);
        }
        w.write("'>\n");
        w.write("<input  type='hidden' name='op' value=''/>\n");
        w.write("<table>");
        if (uicomp.isShowHeader()) {
            w.write("<tr>\n");
            w.write("<th colspan='2'>\n");
            w.write(uploadHeader);
            w.write("</th>\n");
            w.write("</tr>\n");
        }
        int numOfField = uicomp.getNumberOfField();
        for (int i = 1; i <= numOfField; ++i) {
            w.write("<tr>\n");
            w.write("<td>\n");
            w.write(fileLabel + " " + i);
            w.write("</td>\n");
            w.write("<td>\n");
            w.write("<input type='file' name='file-" + i + "'/>");
            w.write("</td>\n");
            w.write("</tr>\n");
            w.write("<tr>\n");
            w.write("<td>\n");
            w.write(nameLabel + " " + i);
            w.write("</td>\n");
            w.write("<td>\n");
            w.write("<input name='name-" + i + "' value=''/>");
            w.write("</td>\n");
            w.write("</tr>\n");
        }
        w.write("<tr>\n");
        w.write(this.getScript());
        w.write("<td colspan='2' align='center' style='padding: 10px'>");
        w.write("<input style='width: auto' type='submit' value='Upload' onclick=\"setAction('upload')\"/>");
        if (uicomp.isShowCancel()) {
            w.write("<input style='width: auto' type='submit' value='Cancel' onclick=\"setAction('cancel')\"/>");
        }
        w.write("</td>");
        w.write("</tr>\n");
        w.write("</table>\n");
        w.write("</form>\n");
    }

    private String getScript() {
        String script = "<script type=\"text/javascript\">\n  function  setAction(action) {\n    document.uploadForm.elements['op'].value =  action ;\n  }\n</script>\n";
        return script;
    }
}

