/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.exoplatform.faces.core.component.UIExoComponent;
import org.exoplatform.faces.core.component.UIHiddenInput;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.component.UISimpleMulltipartForm;
import org.exoplatform.faces.core.component.model.Parameter;

class JSF {
    private static String START_ERROR = "<strike>";
    private static String END_ERROR = "</strike>";
    UIExoComponent uicomponent;
    ResourceBundle res;
    Writer w;

    public JSF(UIExoComponent uicomp, ResourceBundle res, Writer w) {
        this.uicomponent = uicomp;
        this.res = res;
        this.w = w;
    }

    public final void link(String label, Parameter[] params) throws IOException {
        this.link(label, params, null);
    }

    public final void link(String label, Parameter[] params, String id) throws IOException {
        this.w.write("<a  href='");
        this.w.write(this.uicomponent.getBaseURL());
        for (int i = 0; i < params.length; ++i) {
            this.w.write("&amp;");
            this.w.write(params[i].getName());
            this.w.write(61);
            this.w.write(params[i].getValue());
        }
        if (id != null) {
            this.w.write("&amp;");
            this.w.write("objectId");
            this.w.write("=");
            this.w.write(id);
        }
        this.w.write("'>");
        if (label == null) {
            label = "??????";
        }
        if (label.charAt(0) == '@') {
            label = this.res.getString(label);
        }
        this.w.write(label);
        this.w.write("</a>");
    }

    public final void resolve(String key) throws IOException {
        try {
            this.w.write(this.res.getString(key));
        }
        catch (MissingResourceException ex) {
            this.w.write(START_ERROR);
            this.w.write(key);
            this.w.write(END_ERROR);
        }
    }

    public final void formBegin() throws IOException {
        UISimpleForm uiForm = (UISimpleForm)this.uicomponent;
        FacesContext facescontext = FacesContext.getCurrentInstance();
        String actionURL = uiForm.getBaseURL(facescontext);
        String formName = uiForm.getFormName();
        String method = uiForm.getMethod();
        String clazz = uiForm.getClazz();
        if (clazz == null) {
            clazz = "UIExoForm";
        }
        this.w.write("<form id='");
        this.w.write(formName);
        this.w.write("'");
        this.w.write(" action='");
        this.w.write(actionURL);
        this.w.write("'");
        if (method != null) {
            this.w.write(" method='");
            this.w.write(method);
            this.w.write("'");
        }
        if (uiForm instanceof UISimpleMulltipartForm) {
            this.w.write(" enctype='multipart/form-data'");
        }
        this.w.write(">\n");
        this.w.write("<div>\n");
        this.w.write("<input type='hidden' name='");
        this.w.write("op");
        this.w.write("'");
        this.w.write(" value=''/>\n");
        this.w.write("</div>\n");
        List hiddenInputs = uiForm.getHiddenInputs();
        if (hiddenInputs != null) {
            for (int i = 0; i < hiddenInputs.size(); ++i) {
                UIHiddenInput uiInput = (UIHiddenInput)hiddenInputs.get(i);
                uiInput.encodeBegin(facescontext);
            }
        }
    }

    public final void formEnd() throws IOException {
        this.w.write("</form>");
    }

    public final void formInput(String name) throws IOException {
        UISimpleForm uiForm = (UISimpleForm)this.uicomponent;
        UIInput uiInput = uiForm.getUIInput(name);
        if (uiInput != null) {
            FacesContext facescontext = FacesContext.getCurrentInstance();
            uiInput.encodeBegin(facescontext);
            uiInput.encodeChildren(facescontext);
            uiInput.encodeEnd(facescontext);
        } else {
            this.w.write(START_ERROR + "unknown component: " + name + END_ERROR);
        }
    }

    public final void formButton(String label, String action) throws IOException {
        UISimpleForm uiForm = (UISimpleForm)this.uicomponent;
        if (label.charAt(0) == '@') {
            label = label.substring(1);
        }
        try {
            label = this.res.getString(label);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        this.w.write("<a  href=\"javascript:submitForm('");
        this.w.write(uiForm.getFormName());
        this.w.write("','");
        this.w.write(action);
        this.w.write("');\">");
        this.w.write(label);
        this.w.write("</a>");
    }

    public final void renderChild(String id) throws IOException {
        UIExoComponent ui = this.uicomponent.findComponentById(id);
        if (ui != null) {
            FacesContext facescontext = FacesContext.getCurrentInstance();
            ui.encodeBegin(facescontext);
            ui.encodeChildren(facescontext);
            ui.encodeEnd(facescontext);
        } else {
            this.w.write(START_ERROR + "unknown component: " + id + END_ERROR);
        }
    }
}

