/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.component.UITimeInput;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;

public class TimeInputRenderer
extends HtmlBasicRenderer {
    private static final String HOUR_EXTENSION = "_hh";
    private static final String MINUTE_EXTENSION = "_min";

    public void decode(FacesContext context, UIComponent component) {
        UITimeInput uiInput = (UITimeInput)component;
        Calendar cal = uiInput.getCalendar();
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        try {
            String value = (String)paramMap.get(uiInput.getName() + HOUR_EXTENSION);
            cal.set(11, Integer.parseInt(value));
            value = (String)paramMap.get(uiInput.getName() + MINUTE_EXTENSION);
            cal.set(12, Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter w = context.getResponseWriter();
        UITimeInput uiInput = (UITimeInput)component;
        StringBuffer b = new StringBuffer(200);
        ResourceBundle res = TimeInputRenderer.getApplicationResourceBundle(context.getExternalContext());
        String formName = ((UISimpleForm)uiInput.getParent()).getFormName();
        String name = uiInput.getName();
        Calendar cal = uiInput.getCalendar();
        this.renderField(b, uiInput, name + HOUR_EXTENSION, cal.get(11), 0, 23);
        b.append(" : ");
        int minuteStep = uiInput.getMinuteStep_();
        if (minuteStep == 0) {
            minuteStep = 1;
        }
        this.renderField(b, uiInput, name + MINUTE_EXTENSION, cal.get(12), 0, 59, minuteStep);
        w.write(b.toString());
        if (uiInput.hasError()) {
            w.write("<span style='color: red'>*</span>");
        }
    }

    private void renderField(StringBuffer b, UITimeInput uiInput, String name, int value, int minRange, int maxRange, int step) {
        b.append("<select  style='width: auto;' name='").append(name).append("'");
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            b.append(" disabled='true'");
        }
        if (uiInput.getClazz() != null) {
            b.append(" class='").append(uiInput.getClazz()).append("'");
        }
        b.append(">\n");
        DecimalFormat df = new DecimalFormat("00");
        for (int i = minRange; i <= maxRange; i += step) {
            if (i == value) {
                b.append("<option selected=\"selected\" value=\"").append(i).append("\">").append(df.format(i)).append("</option>\n");
                continue;
            }
            b.append("<option value=\"").append(i).append("\">").append(df.format(i)).append("</option>\n");
        }
        b.append("</select>\n");
    }

    private void renderField(StringBuffer b, UITimeInput uiInput, String name, int value, int minRange, int maxRange) {
        this.renderField(b, uiInput, name, value, minRange, maxRange, 1);
    }

    private void renderField(StringBuffer b, UITimeInput uiInput, String name, int value, String[] values) {
        b.append("<select style='width: auto;' name='").append(name).append("'");
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            b.append(" disabled='true'");
        }
        if (uiInput.getClazz() != null) {
            b.append(" class='").append(uiInput.getClazz()).append("'");
        }
        b.append(">\n");
        for (int i = 0; i < values.length; ++i) {
            if (i == value) {
                b.append("<option selected=\"selected\" value=\"").append(i).append("\">").append(values[i]).append("</option>\n");
                continue;
            }
            b.append("<option value=\"").append(i).append("\">").append(values[i]).append("</option>\n");
        }
        b.append("</select>\n");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

