/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.renderer.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.FacesUtil;
import org.exoplatform.faces.core.component.UIWYSIWYG;
import org.exoplatform.faces.core.renderer.html.HtmlBasicRenderer;

public class WYSIWYGRenderer
extends HtmlBasicRenderer {
    public static String DEFAULT = "default";
    public static String BASIC = "basic";
    public static String INPUT_ONLY = "input-only";

    public void decode(FacesContext context, UIComponent component) {
        UIWYSIWYG uiInput = (UIWYSIWYG)component;
        if (!uiInput.isEditable() || uiInput.isReadonly()) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)paramMap.get(uiInput.getName());
        if (value == null) {
            return;
        }
        if (!FacesUtil.updateBoundValueBinding(context, component, "text", value)) {
            uiInput.setText(value);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIWYSIWYG uiHtmlArea = (UIWYSIWYG)component;
        ResponseWriter w = context.getResponseWriter();
        String value = uiHtmlArea.getText();
        String htmlType = uiHtmlArea.getHtmlType();
        String portalName = PortalContainer.getInstance().getPortalContainerInfo().getContainerName();
        if (value == null) {
            value = "";
        }
        w.write("<script type=\"text/javascript\" src=\"/" + portalName + "/FCKeditor/fckeditor.js\"></script>");
        w.write("<script>");
        w.write(" var fckeditor" + uiHtmlArea.getName() + " = new FCKeditor( '" + uiHtmlArea.getName() + "' ); \n");
        String basePath = "/" + portalName + "/FCKeditor/";
        w.write(" fckeditor" + uiHtmlArea.getName() + ".BasePath\t= '" + basePath + "' ; \n");
        if (htmlType != null && htmlType.equalsIgnoreCase(BASIC)) {
            w.write("\tfckeditor" + uiHtmlArea.getName() + ".ToolbarSet\t= 'Basic' ; \n");
        } else if (htmlType != null && htmlType.equalsIgnoreCase(INPUT_ONLY)) {
            w.write("\tfckeditor" + uiHtmlArea.getName() + ".ToolbarSet\t= 'InputOnly' ; \n");
            w.write("\tfckeditor" + uiHtmlArea.getName() + ".Height\t= '50px' ; \n");
        } else {
            w.write("\tfckeditor" + uiHtmlArea.getName() + ".Height\t= '400px' ; \n");
        }
        value = value.replaceAll("'", "\\\\'");
        value = value.replaceAll("[\r\n]", "");
        w.write("\tfckeditor" + uiHtmlArea.getName() + ".Value\t= '");
        w.write(value);
        w.write("' ; \n");
        w.write("\tfckeditor" + uiHtmlArea.getName() + ".Create(); \n");
        w.write("</script>");
    }
}

