/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.core.validator;

import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.application.ExoFacesMessage;
import org.exoplatform.faces.core.Util;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;

public class PermissionValidator
implements Validator {
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceBundle res = Util.getApplicationResourceBundle();
        String s = (String)value;
        MembershipType membershipType = null;
        Group group = null;
        OrganizationService service = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        if (s != null && s.length() > 0 && !s.equals("*")) {
            UIInput uiInput = (UIInput)component;
            Object[] args = new Object[]{uiInput.getName()};
            String[] tmp = s.split(":", 2);
            if (tmp.length != 2) {
                uiInput.setValue("");
                throw new ValidatorException((FacesMessage)new ExoFacesMessage(res.getString("PermissionValidator.msg.invalid-permission-input"), args));
            }
            String membership = tmp[0];
            String groupId = tmp[1];
            try {
                membershipType = service.getMembershipTypeHandler().findMembershipType(membership);
                group = service.getGroupHandler().findGroupById(groupId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!membership.equals("*")) {
                if (membershipType == null || group == null) {
                    uiInput.setValue("");
                    throw new ValidatorException((FacesMessage)new ExoFacesMessage(res.getString("PermissionValidator.msg.membership-group-not-found"), args));
                }
            } else if (group == null) {
                uiInput.setValue("");
                throw new ValidatorException((FacesMessage)new ExoFacesMessage(res.getString("PermissionValidator.msg.membership-group-not-found"), args));
            }
        }
    }
}

