/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.session;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;

public class PortalResources {
    private ResourceBundle portalResource_;
    private ResourceBundle portalOwnerResource_;
    private LocaleConfig localeConfig_;

    public void changeLocaleConfig(String localeStr, String owner) {
        LocaleConfigService manager = (LocaleConfigService)PortalContainer.getComponent(LocaleConfigService.class);
        this.localeConfig_ = manager.getLocaleConfig(localeStr);
        Locale locale = this.localeConfig_.getLocale();
        ResourceBundleService service = (ResourceBundleService)PortalContainer.getComponent(ResourceBundleService.class);
        this.portalResource_ = service.getResourceBundle(service.getSharedResourceBundleNames(), locale);
        this.portalOwnerResource_ = this.localeConfig_.getOwnerResourceBundle(owner);
        try {
            this.portalOwnerResource_ = service.getResourceBundle("locale.users." + owner, this.localeConfig_.getLocale());
            if (this.portalOwnerResource_ == null) {
                this.portalOwnerResource_ = service.getResourceBundle("locale.users.default", locale);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LocaleConfig getLocaleConfig() {
        return this.localeConfig_;
    }

    public Locale getLocale() {
        return this.localeConfig_.getLocale();
    }

    public ResourceBundle getPortalResourceBundle() {
        return this.portalResource_;
    }

    public ResourceBundle getPortalOwnerResourceBundle() {
        return this.portalOwnerResource_;
    }

    public ResourceBundle getApplicationResource() {
        return this.portalResource_;
    }

    public ResourceBundle getApplicationOwnerResource() {
        return this.portalOwnerResource_;
    }

    public ResourceBundle getApplicationResource(String name) {
        return this.localeConfig_.getResourceBundle(name);
    }

    public ResourceBundle getApplicationOwnerResource(String owner) {
        return this.localeConfig_.getOwnerResourceBundle(owner);
    }
}

