/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.session;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.faces.context.PortletFacesContext;
import org.exoplatform.portal.session.ExoPortal;

public class RequestInfo {
    public static final String PORTAL_VIEW_ID = "/portal.jsp";
    public static final String PAGE_VIEW_ID = "/page.jsp";
    public static final String PRIVATE_ACCESS = "private";
    public static final String PUBLIC_ACCESS = "public";
    public static final String ADMIN_ACCESS = "admin";
    private String portalOwner_;
    private String nodePath_;
    private String portalAction_;
    private String targetComponentId_;
    private String portletWindowState_;
    private String portletMode_;
    private String portletActionType_;
    private String lang_;
    private String accessibility_;
    private String contextPath_;
    private String ownerURI_;
    private String nodeURI_;
    private String viewId_;
    private boolean newSession_ = false;
    private String remoteUser;

    public void init(HttpServletRequest req) {
        this.remoteUser = req.getRemoteUser();
        String requestURI = req.getRequestURI();
        if (requestURI.indexOf("/faces/public") > 0) {
            this.accessibility_ = PUBLIC_ACCESS;
        } else if (requestURI.indexOf("/faces/private") > 0) {
            this.accessibility_ = PRIVATE_ACCESS;
        } else if (requestURI.indexOf("/faces/admin") > 0) {
            this.accessibility_ = ADMIN_ACCESS;
        } else {
            throw new RuntimeException("unknown  access type: " + requestURI);
        }
        String pathInfo = req.getPathInfo();
        int slashIndex = pathInfo.indexOf(47, 1);
        if (slashIndex > 0) {
            this.portalOwner_ = pathInfo.substring(1, slashIndex);
            this.nodePath_ = pathInfo.substring(slashIndex, pathInfo.length());
        } else {
            this.portalOwner_ = pathInfo.substring(1, pathInfo.length());
            this.nodePath_ = null;
        }
        this.viewId_ = PAGE_VIEW_ID.equals(pathInfo) ? PAGE_VIEW_ID : PORTAL_VIEW_ID;
        this.portalAction_ = req.getParameter("portal:action");
        this.targetComponentId_ = req.getParameter("portal:componentId");
        this.portletWindowState_ = req.getParameter("portal:windowState");
        this.portletMode_ = req.getParameter("portal:portletMode");
        this.portletActionType_ = req.getParameter("portal:type");
        this.lang_ = req.getParameter("portal:lang");
        this.contextPath_ = req.getContextPath();
        this.ownerURI_ = this.contextPath_ + "/faces/" + this.accessibility_ + "/" + this.portalOwner_;
        this.nodeURI_ = null;
    }

    public String getPortalOwner() {
        return this.portalOwner_;
    }

    public String getPageName() {
        return this.nodePath_;
    }

    public String getPortalAction() {
        return this.portalAction_;
    }

    public String getTargetComponentId() {
        return this.targetComponentId_;
    }

    public String getPortletWindowState() {
        return this.portletWindowState_;
    }

    public String getPortletMode() {
        return this.portletMode_;
    }

    public String getPortletActionType() {
        return this.portletActionType_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public String getContextPath() {
        return this.contextPath_;
    }

    public String getAccessibility() {
        return this.accessibility_;
    }

    public String getViewId() {
        return this.viewId_;
    }

    public String getOwnerURI() {
        return this.ownerURI_;
    }

    public String getNodeURI() {
        if (this.nodeURI_ == null) {
            this.nodeURI_ = this.nodePath_ == null ? this.ownerURI_ : this.ownerURI_ + this.nodePath_;
        }
        return this.nodeURI_;
    }

    public boolean isNewSession() {
        return this.newSession_;
    }

    public void setNewSession(boolean b) {
        this.newSession_ = b;
    }

    public ExoPortal getPortal() {
        FacesContext portalContext = FacesContext.getCurrentInstance();
        if (portalContext instanceof PortletFacesContext) {
            portalContext = ((PortletFacesContext)portalContext).getPortalFacesContext();
        }
        return (ExoPortal)portalContext.getViewRoot().getChildren().get(0);
    }

    public static String getPortalOwner(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        int slashIndex = pathInfo.indexOf(47, 1);
        String owner = null;
        owner = slashIndex > 0 ? pathInfo.substring(1, slashIndex) : pathInfo.substring(1, pathInfo.length());
        return owner;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }
}

