/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.community;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.community.CommunityEventListener;
import org.exoplatform.portal.community.CommunityNavigation;
import org.exoplatform.portal.community.CommunityPortal;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;

public class CommunityConfigService {
    static CommunityPortal NO_COMMUNITY_PORTAL = new CommunityPortal();
    static CommunityNavigation NO_COMMUNITY_NAVIGATION = new CommunityNavigation();
    private OrganizationService orgService_;
    private HibernateService hservice_;
    private ExoCache cpCache_;
    private ExoCache cnCache_;
    private List<CommunityEventListener> listeners_ = new ArrayList<CommunityEventListener>(3);

    public CommunityConfigService(InitParams params, HibernateService hservice, CacheService cservice, OrganizationService orgService) throws Exception {
        this.orgService_ = orgService;
        this.hservice_ = hservice;
        this.cpCache_ = cservice.getCacheInstance(CommunityPortal.class.getName());
        this.cnCache_ = cservice.getCacheInstance(CommunityNavigation.class.getName());
        this.initDb(params);
    }

    public final List getCommunityEventListeners() {
        return this.listeners_;
    }

    public void addCommunityEventListener(ComponentPlugin listener) {
        if (listener instanceof CommunityEventListener) {
            this.listeners_.add((CommunityEventListener)listener);
        }
    }

    private void initDb(InitParams params) throws Exception {
        try {
            List list = this.hservice_.openSession().createCriteria(CommunityPortal.class).list();
            if (list.size() == 0) {
                int i;
                list = params.getObjectParamValues(CommunityPortal.class);
                if (list != null) {
                    for (i = 0; i < list.size(); ++i) {
                        CommunityPortal cp = (CommunityPortal)list.get(i);
                        this.hservice_.save((Object)cp);
                    }
                }
                if ((list = params.getObjectParamValues(CommunityNavigation.class)) != null) {
                    for (i = 0; i < list.size(); ++i) {
                        CommunityNavigation cn = (CommunityNavigation)list.get(i);
                        this.hservice_.save((Object)cn);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public CommunityPortal createCommunityPortal() {
        return new CommunityPortal();
    }

    public CommunityPortal getCommunityPortal(String groupId) throws Exception {
        CommunityPortal cportal = (CommunityPortal)this.cpCache_.get((Serializable)((Object)groupId));
        if (cportal == null) {
            cportal = (CommunityPortal)this.hservice_.findOne(CommunityPortal.class, (Serializable)((Object)groupId));
            if (cportal == null) {
                this.cpCache_.put((Serializable)((Object)groupId), (Object)NO_COMMUNITY_PORTAL);
            } else {
                this.cpCache_.put((Serializable)((Object)groupId), (Object)cportal);
            }
        }
        if (cportal == NO_COMMUNITY_PORTAL) {
            return null;
        }
        return cportal;
    }

    public CommunityPortal findCommunityPortal(String user) throws Exception {
        Collection memberships = this.orgService_.getMembershipHandler().findMembershipsByUser(user);
        CommunityPortal found = null;
        for (Membership m : memberships) {
            CommunityPortal cp = this.getCommunityPortal(m.getGroupId());
            if (cp == null || !cp.getMembership().equals(m.getMembershipType()) || found != null && cp.getPriority() >= found.getPriority()) continue;
            found = cp;
        }
        return found;
    }

    public void addCommunityPortal(CommunityPortal cp) throws Exception {
        this.hservice_.save((Object)cp);
        this.cpCache_.remove((Serializable)((Object)cp.getGroupId()));
        this.onChange(cp);
    }

    public void removeCommunityPortal(CommunityPortal cp) throws Exception {
        this.hservice_.remove(CommunityPortal.class, (Serializable)((Object)cp.getGroupId()));
        this.cpCache_.remove((Serializable)((Object)cp.getGroupId()));
        this.onChange(cp);
    }

    public CommunityNavigation createCommunityNavigation() {
        return new CommunityNavigation();
    }

    public CommunityNavigation getCommunityNavigation(String groupId) throws Exception {
        CommunityNavigation cnav = (CommunityNavigation)this.cnCache_.get((Serializable)((Object)groupId));
        if (cnav == null) {
            cnav = (CommunityNavigation)this.hservice_.findOne(CommunityNavigation.class, (Serializable)((Object)groupId));
            if (cnav == null) {
                cnav = NO_COMMUNITY_NAVIGATION;
            }
            this.cnCache_.put((Serializable)((Object)groupId), (Object)cnav);
        }
        if (cnav == NO_COMMUNITY_NAVIGATION) {
            return null;
        }
        return cnav;
    }

    public List findCommunityNavigation(String user) throws Exception {
        ArrayList<CommunityNavigation> list = new ArrayList<CommunityNavigation>();
        Collection memberships = this.orgService_.getMembershipHandler().findMembershipsByUser(user);
        for (Membership m : memberships) {
            CommunityNavigation cn = this.getCommunityNavigation(m.getGroupId());
            if (cn == null || !cn.getMembership().equals(m.getMembershipType())) continue;
            list.add(cn);
        }
        return list;
    }

    public void addCommunityNavigation(CommunityNavigation cn) throws Exception {
        this.hservice_.save((Object)cn);
        this.cnCache_.remove((Serializable)((Object)cn.getGroupId()));
        this.onChange(cn);
    }

    public void removeCommunityNavigation(CommunityNavigation cn) throws Exception {
        this.hservice_.remove(CommunityNavigation.class, (Serializable)((Object)cn.getGroupId()));
        this.cnCache_.remove((Serializable)((Object)cn.getGroupId()));
        this.onChange(cn);
    }

    private void onChange(CommunityNavigation cn) throws Exception {
        for (CommunityEventListener listener : this.listeners_) {
            listener.onChange(cn);
        }
    }

    private void onChange(CommunityPortal cp) throws Exception {
        for (CommunityEventListener listener : this.listeners_) {
            listener.onChange(cp);
        }
    }
}

