/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.content;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.portal.config.content.ContentPlugin;
import org.exoplatform.portal.config.content.DocumentContent;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalContentService
implements Startable,
ComponentPlugin {
    private static final String findAllDocuments = "from d in class org.exoplatform.portal.config.content.DocumentContent";
    private static final String findDocumentById = "from d in class org.exoplatform.portal.config.content.DocumentContent where d.id = ? ";
    private static final String findDocumentsByOwner = "from d in class org.exoplatform.portal.config.content.DocumentContent where d.owner = ? ";
    private static final String ENCODING = "UTF-8";
    private HibernateService hservice_;
    private ServletContext sContext_;
    private LocaleConfigService localeConfigService_;
    private ExoCache contentCache_;

    public PortalContentService(HibernateService hservice, ServletContext servletContext, CacheService cacheService, LocaleConfigService localeConfigService) throws Exception {
        this.hservice_ = hservice;
        this.sContext_ = servletContext;
        this.localeConfigService_ = localeConfigService;
        this.contentCache_ = cacheService.getCacheInstance(DocumentContent.class.getName());
    }

    public void addContentPlugin(ComponentPlugin plugin) throws Exception {
        ContentPlugin contentPlugin = (ContentPlugin)plugin;
        this.initDatabase(contentPlugin);
    }

    public DocumentContent createDocumentContentInstance() {
        return new DocumentContent();
    }

    public DocumentContent getDocumentById(String id) throws Exception {
        DocumentContent document = (DocumentContent)this.contentCache_.get((Serializable)((Object)id));
        if (document != null) {
            return document;
        }
        Session session = this.hservice_.openSession();
        document = (DocumentContent)this.hservice_.findOne(session, findDocumentById, id);
        if (document != null) {
            this.contentCache_.put((Serializable)((Object)id), (Object)document);
        }
        return document;
    }

    public List<DocumentContent> getDocumentsByGroupId(String groupId) throws Exception {
        ArrayList<DocumentContent> documents = new ArrayList();
        ObjectQuery query = new ObjectQuery(DocumentContent.class);
        query.addLIKE("id", groupId + "%");
        Session session = this.hservice_.openSession();
        documents = session.createQuery(query.getHibernateQuery()).list();
        return documents;
    }

    public void save(DocumentContent document) throws Exception {
        Session session = this.hservice_.openSession();
        Transaction transaction = session.beginTransaction();
        this.hservice_.save((Object)document);
        transaction.commit();
    }

    public List<DocumentContent> getDocumentsByOwner(String owner) throws Exception {
        Session session = this.hservice_.openSession();
        List documents = session.createQuery(findDocumentsByOwner).setString(0, owner).list();
        return documents;
    }

    public List<DocumentContent> getAllDocuments() throws Exception {
        Session session = this.hservice_.openSession();
        List documents = session.createQuery(findAllDocuments).list();
        return documents;
    }

    public void update(DocumentContent document) throws Exception {
        Session session = this.hservice_.openSession();
        Transaction transaction = session.beginTransaction();
        session.update((Object)document);
        transaction.commit();
    }

    public void remove(DocumentContent document) throws Exception {
        Session session = this.hservice_.openSession();
        Transaction transaction = session.beginTransaction();
        session.delete((Object)document);
        transaction.commit();
        this.contentCache_.remove((Serializable)((Object)document.getId()));
    }

    public void initDatabase(ContentPlugin plugin) throws Exception {
        String content = null;
        String owner = plugin.getContentOwner();
        Collection configs = this.localeConfigService_.getLocalConfigs();
        List contentIds = plugin.getContentIds();
        for (String id : contentIds) {
            if (!id.startsWith("war:") && !id.startsWith("file://")) continue;
            if (id.endsWith(".html")) {
                try {
                    content = null;
                    content = this.getExternalContent(id, ENCODING);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (content == null) continue;
                this.initContent(id, content, owner);
                continue;
            }
            String tmpId = id + ".html";
            try {
                content = null;
                content = this.getExternalContent(tmpId, ENCODING);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (content != null) {
                String realId = id + "_en.html";
                this.initContent(realId, content, owner);
            }
            for (LocaleConfig localeConfig : configs) {
                String tmpUri = id + "_" + localeConfig.getLanguage() + ".html";
                try {
                    content = null;
                    content = this.getExternalContent(tmpUri, ENCODING);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (content == null) continue;
                this.initContent(tmpUri, content, owner);
            }
        }
    }

    private void initContent(String id, String content, String owner) throws Exception {
        if (this.getDocumentById(id) == null) {
            this.storeContent(id, content, owner);
        }
    }

    private void storeContent(String id, String content, String owner) throws Exception {
        DocumentContent documentContent = this.createDocumentContentInstance();
        documentContent.setId(id);
        documentContent.setContent(content);
        documentContent.setOwner(owner);
        this.save(documentContent);
    }

    public String getExternalContent(String uri, String encoding) throws Exception {
        String content = null;
        if (uri.startsWith("war:")) {
            String path = uri.substring(4, uri.length());
            InputStream is = this.sContext_.getResourceAsStream(path);
            if (is == null) {
                throw new IOException();
            }
            byte[] buf = new byte[is.available()];
            is.read(buf);
            content = new String(buf, encoding);
        } else if (uri.startsWith("file://")) {
            String path = uri.substring(7, uri.length());
            FileInputStream is = new FileInputStream(path);
            if (is == null) {
                throw new IOException();
            }
            byte[] buf = new byte[is.available()];
            is.read(buf);
            content = new String(buf, encoding);
        }
        return content;
    }

    public void start() {
    }

    public void stop() {
    }

    public String getName() {
        return null;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String s) {
    }
}

