/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.impl.NodeNavigationData;
import org.exoplatform.portal.config.impl.PageData;
import org.exoplatform.portal.config.impl.PortalConfigData;
import org.exoplatform.portal.config.model.NodeNavigation;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.backup.ImportExportPlugin;
import org.exoplatform.services.backup.Metadata;
import org.exoplatform.services.backup.XMLObjectConverter;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLObject;
import org.hibernate.Session;

public class ImportExportPluginImpl
extends ImportExportPlugin {
    static String PLUGIN_NAME = "portal";
    static String META_DATA_ENTRY = "portal/metadata.xml";
    static String PORTAL_CONFIG_ENTRY = "portal/portal-config.xml";
    static String PAGES_CONFIG_ENTRY = "portal/pages-config.xml";
    static String NAVIGATION_CONFIG_ENTRY = "portal/navigation-config.xml";
    HibernateService hservice_;

    public ImportExportPluginImpl(HibernateService hservice, InitParams params) throws Exception {
        this.hservice_ = hservice;
        this.init(params);
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return "Export the user portal configuration";
    }

    public boolean hasServiceData() {
        return false;
    }

    public void exportUserData(String userName, ZipOutputStream os) throws Exception {
        Session session = this.hservice_.openSession();
        Metadata mdata = new Metadata(this.getCurrentDataVersion(), this.getDescription(), "single-user");
        this.createEntry(META_DATA_ENTRY, os, mdata);
        PortalConfigData data = (PortalConfigData)session.get(PortalConfigData.class, (Serializable)((Object)userName));
        if (data != null) {
            this.createEntry(PORTAL_CONFIG_ENTRY, os, data.getPortalConfig());
        }
        List l = session.createQuery("from pd in class org.exoplatform.portal.config.impl.PageData where pd.owner = ? ").setString(0, userName).list();
        ArrayList<Page> pages = new ArrayList<Page>(l.size() + 5);
        for (int i = 0; i < l.size(); ++i) {
            PageData pageData = (PageData)l.get(i);
            pages.add(pageData.getPage());
        }
        this.createEntry(PAGES_CONFIG_ENTRY, os, pages);
        NodeNavigationData nvdata = (NodeNavigationData)session.get(NodeNavigationData.class, (Serializable)((Object)userName));
        if (nvdata != null) {
            this.createEntry(NAVIGATION_CONFIG_ENTRY, os, nvdata.getNodeNavigation());
        }
        session.flush();
    }

    public void importUserData(String user, ZipFile in) throws Exception {
        XMLObject xmlobject;
        Session session = this.hservice_.openSession();
        Metadata mdata = this.getMetadata(META_DATA_ENTRY, in);
        String version = mdata.getDataVersion();
        XMLObjectConverter converter = this.getXMLObjectConverter(version);
        InputStream entry = this.getEntry(PORTAL_CONFIG_ENTRY, in);
        if (entry != null) {
            xmlobject = XMLObject.getXMLObject((InputStream)entry);
            if (converter != null) {
                converter.traverse(xmlobject);
                converter.pack(xmlobject);
            }
            PortalConfig pconfig = (PortalConfig)xmlobject.toObject();
            session.save((Object)new PortalConfigData(pconfig));
        }
        if ((entry = this.getEntry(PAGES_CONFIG_ENTRY, in)) != null) {
            XMLCollection xmlcol = XMLCollection.getXMLCollection((InputStream)entry);
            if (converter != null) {
                converter.traverse(xmlcol);
            }
            Collection pages = xmlcol.getCollection();
            for (Page page : pages) {
                session.save((Object)new PageData(page));
            }
        }
        if ((entry = this.getEntry(NAVIGATION_CONFIG_ENTRY, in)) != null) {
            xmlobject = XMLObject.getXMLObject((InputStream)entry);
            if (converter != null) {
                converter.traverse(xmlobject);
            }
            NodeNavigation nn = (NodeNavigation)xmlobject.toObject();
            session.save((Object)new NodeNavigationData(nn));
        }
        if (entry != null) {
            entry.close();
        }
        if (session != null) {
            session.flush();
        }
    }

    public void exportServiceData(ZipOutputStream os) throws Exception {
    }

    public void importServiceData(ZipFile in) throws Exception {
    }
}

