/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import java.util.Collection;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.config.PortalACL;
import org.exoplatform.portal.config.model.Node;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.Permission;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Portlet;
import org.exoplatform.services.organization.OrganizationService;

public class PortalACLImpl
implements PortalACL {
    private OrganizationService service_;

    public PortalACLImpl(OrganizationService service) {
        this.service_ = service;
    }

    public boolean hasViewPagePermission(Page page, String remoteUser) throws Exception {
        if (page == null) {
            return false;
        }
        if (page.getOwner().equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, page.getViewPermission());
    }

    public boolean hasEditPagePermission(Page page, String remoteUser) throws Exception {
        if (page == null) {
            return false;
        }
        if (page.getOwner().equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, page.getEditPermission());
    }

    public boolean hasViewPortalPermission(PortalConfig config, String remoteUser) throws Exception {
        if (config == null) {
            return false;
        }
        if (config.getOwner().equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, config.getViewPermission());
    }

    public boolean hasEditPortalPermission(PortalConfig config, String remoteUser) throws Exception {
        if (config == null) {
            return false;
        }
        if (config.getOwner().equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, config.getEditPermission());
    }

    public boolean hasViewNodePermission(Node node, String portalOwner, String remoteUser) throws Exception {
        if (node == null) {
            return false;
        }
        if (portalOwner.equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, node.getViewPermission());
    }

    public boolean hasEditNodePermission(Node node, String portalOwner, String remoteUser) throws Exception {
        if (node == null) {
            return false;
        }
        if (portalOwner.equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, node.getEditPermission());
    }

    public boolean hasEditPreferencesPermission(Portlet portlet, String portletOwner, String remoteUser) throws Exception {
        if (portlet == null) {
            return false;
        }
        if (portletOwner.equals(remoteUser)) {
            return true;
        }
        if (this.hasRoleAdmin()) {
            return true;
        }
        return this.hasPermission(remoteUser, portlet.getEditPreferencesPermission());
    }

    private boolean hasPermission(String remoteUser, Permission perm) throws Exception {
        if (perm == null) {
            return false;
        }
        String groupId = perm.getGroup();
        if ("/guest".equals(groupId)) {
            return true;
        }
        String membership = perm.getMembership();
        if (membership == null || "*".equals(membership)) {
            Collection c = this.service_.getMembershipHandler().findMembershipsByUserAndGroup(remoteUser, groupId);
            if (c == null) {
                return false;
            }
            return c.size() > 0;
        }
        return this.service_.getMembershipHandler().findMembershipByUserGroupAndType(remoteUser, groupId, membership) != null;
    }

    private boolean hasRoleAdmin() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null || context.getExternalContext() == null) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        return request.isUserInRole("admin");
    }
}

