/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.Interceptor;
import org.exoplatform.portal.config.PortalACL;
import org.exoplatform.portal.config.PortalConfigService;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.impl.NodeImpl;
import org.exoplatform.portal.config.impl.NodeNavigationData;
import org.exoplatform.portal.config.impl.PageData;
import org.exoplatform.portal.config.impl.PageDescriptionData;
import org.exoplatform.portal.config.impl.PortalConfigData;
import org.exoplatform.portal.config.impl.PortalConfigDescriptionData;
import org.exoplatform.portal.config.model.Node;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageSet;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExpireKeyStartWithSelector;
import org.exoplatform.services.database.DBObjectPageList;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.hibernate.Session;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;

public class PortalConfigServiceImpl
implements PortalConfigService {
    public static final String queryPageDataByOwner = "from pd in class org.exoplatform.portal.config.impl.PageData where pd.owner = ? ";
    public static final String queryNodeNavigationData = "from nv in class org.exoplatform.portal.config.impl.NodeNavigationData where nv.owner = ? ";
    private PortalACL portalACL_;
    private HibernateService hservice_;
    private Map predefinedTemplates_;
    private Interceptor interceptor_;
    private ExoCache portalConfigCache_;
    private ExoCache pageConfigCache_;
    private ExoCache nodeNavigationCache_;

    public PortalConfigServiceImpl(Interceptor interceptor, PortalACL portalACL, CacheService cacheService, HibernateService hservice, InitParams params, ConfigurationManager cservice) throws Exception {
        this.interceptor_ = interceptor;
        this.hservice_ = hservice;
        this.portalACL_ = portalACL;
        this.portalConfigCache_ = cacheService.getCacheInstance(PortalConfig.class.getName());
        this.pageConfigCache_ = cacheService.getCacheInstance(Page.class.getName());
        this.nodeNavigationCache_ = cacheService.getCacheInstance(NodeImpl.class.getName());
        String templateLocation = params.getValueParam("templateLocation").getValue();
        String xml = IOUtil.getStreamContentAsString((InputStream)cservice.getInputStream(templateLocation + "/templates.xml"));
        this.initPredefinedTemplates(xml);
    }

    public void initPredefinedTemplates(String xml) throws Exception {
        this.predefinedTemplates_ = new HashMap();
        PageSet ps = (PageSet)PortalConfigServiceImpl.unmarshall(new ByteArrayInputStream(xml.getBytes()), PageSet.class);
        List pages = ps.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            Page page = (Page)pages.get(i);
            this.predefinedTemplates_.put(page.getOwner() + ":" + page.getName(), page);
        }
    }

    public void savePortalConfig(String owner, String xml, String remoteUser) throws Exception {
        this.hservice_.save((Object)new PortalConfigData(xml));
        this.portalConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(owner));
    }

    public void savePortalConfig(PortalConfig config, String remoteUser) throws Exception {
        this.interceptor_.savePortalConfig(config);
        this.portalConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(config.getOwner()));
    }

    public PortalConfig getPortalConfig(String owner, String remoteUser) throws Exception {
        String cacheKey;
        PortalConfig config;
        if (remoteUser == null || remoteUser.length() < 1) {
            remoteUser = "guest";
        }
        if ((config = (PortalConfig)this.portalConfigCache_.get((Serializable)((Object)(cacheKey = this.generateCacheId(owner, remoteUser))))) != null) {
            return config;
        }
        config = this.interceptor_.getPortalConfig(owner);
        if (config != null) {
            this.portalConfigCache_.put((Serializable)((Object)cacheKey), (Object)config);
        }
        return config;
    }

    public String getPortalConfigAsXmlString(String owner, String remoteUser) throws Exception {
        PortalConfigData data = (PortalConfigData)this.hservice_.findOne(PortalConfigData.class, (Serializable)((Object)owner));
        return data.getData();
    }

    public PageList findAllPortalConfigDescriptions(Query q) throws Exception {
        String owner = q.getOwner();
        if (owner == null || owner.length() == 0) {
            owner = "%";
        }
        owner = owner.replace('*', '%');
        String viewPermission = q.getViewPermission();
        String editPermission = q.getEditPermission();
        ObjectQuery oq = new ObjectQuery(PortalConfigDescriptionData.class);
        oq.addLIKE("id", owner);
        if (viewPermission != null && viewPermission.length() > 0) {
            oq.addEQ("viewPermission", (Object)viewPermission);
        }
        if (editPermission != null && editPermission.length() > 0) {
            oq.addEQ("editPermission", (Object)editPermission);
        }
        return new DBObjectPageList(this.hservice_, oq);
    }

    public void removePortalConfig(String owner, String remoteUser) throws Exception {
        this.hservice_.remove(PortalConfigData.class, (Serializable)((Object)owner));
        this.portalConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(owner));
    }

    public void savePage(String xml, String remoteUser) throws Exception {
        PageData data = new PageData(xml);
        this.hservice_.save((Object)data);
        this.pageConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(data.getId()));
    }

    public void savePage(Page page, String remoteUser) throws Exception {
        this.interceptor_.savePage(page);
        this.pageConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(PageData.getId(page)));
    }

    public Page getPage(String pageId, String remoteUser) throws Exception {
        String cacheKey;
        Page page;
        if (remoteUser == null || remoteUser.length() < 1) {
            remoteUser = "guest";
        }
        if ((page = (Page)this.pageConfigCache_.get((Serializable)((Object)(cacheKey = this.generateCacheId(pageId, remoteUser))))) != null) {
            return page;
        }
        page = this.interceptor_.getPage(pageId, remoteUser);
        this.pageConfigCache_.put((Serializable)((Object)cacheKey), (Object)page);
        return page;
    }

    public String getPageAsXmlString(String refId, String remoteUser) throws Exception {
        PageData data = (PageData)this.hservice_.findOne(PageData.class, (Serializable)((Object)refId));
        return data.getData();
    }

    public void removePage(String refId, String remoteUser) throws Exception {
        this.hservice_.remove(PageData.class, (Serializable)((Object)refId));
        this.pageConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(refId));
    }

    private String generateCacheId(String refId, String remoteUser) {
        return refId + "." + remoteUser;
    }

    public void removePageOfOwner(String owner, String remoteUser) throws Exception {
        Session session = this.hservice_.openSession();
        List entries = session.createQuery(queryPageDataByOwner).setString(0, owner).list();
        for (int i = 0; i < entries.size(); ++i) {
            session.delete(entries.get(i));
        }
        session.flush();
        this.pageConfigCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(owner));
    }

    public PageList findAllPageDescriptions(Query q) throws Exception {
        String owner = q.getOwner();
        if (owner == null || owner.length() == 0) {
            owner = "%";
        }
        owner = owner.replace('*', '%');
        String viewPermission = q.getViewPermission();
        String editPermission = q.getEditPermission();
        ObjectQuery oq = new ObjectQuery(PageDescriptionData.class);
        oq.addLIKE("owner", owner);
        if (viewPermission != null && viewPermission.length() > 0) {
            if (viewPermission.indexOf("*") > -1) {
                viewPermission = viewPermission.replace('*', '%');
                oq.addLIKE("viewPermission", viewPermission);
            } else if (viewPermission.indexOf(":/") == 0) {
                viewPermission = "%" + viewPermission;
                oq.addLIKE("viewPermission", viewPermission);
            } else {
                oq.addEQ("viewPermission", (Object)viewPermission);
            }
        }
        if (editPermission != null && editPermission.length() > 0) {
            if (editPermission.indexOf("*") > -1) {
                editPermission = editPermission.replace('*', '%');
                oq.addLIKE("editPermission", editPermission);
            } else if (editPermission.indexOf(":/") == 0) {
                editPermission = "%" + editPermission;
                oq.addLIKE("editPermission", editPermission);
            } else {
                oq.addEQ("editPermission", (Object)editPermission);
            }
        }
        return new DBObjectPageList(this.hservice_, oq);
    }

    public void saveNodeNavigation(String owner, Node node, String remoteUser) throws Exception {
        this.interceptor_.saveNodeNavigation(owner, node);
        this.nodeNavigationCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(owner));
    }

    public void removeNodeNavigation(String owner, String remoteUser) throws Exception {
        this.hservice_.remove(NodeNavigationData.class, (Serializable)((Object)owner));
        this.nodeNavigationCache_.select((CachedObjectSelector)new ExpireKeyStartWithSelector(owner));
    }

    public Node getNodeNavigation(String owner, String remoteUser) throws Exception {
        String cacheKey;
        Node node;
        if (remoteUser == null || remoteUser.length() < 1) {
            remoteUser = "guest";
        }
        if ((node = (Node)this.nodeNavigationCache_.get((Serializable)((Object)(cacheKey = this.generateCacheId(owner, remoteUser))))) == null) {
            node = this.interceptor_.getNodeNavigation(owner, remoteUser);
            this.nodeNavigationCache_.put((Serializable)((Object)cacheKey), (Object)node);
        }
        if (node == null) {
            return null;
        }
        return new NodeImpl(node, null, 0);
    }

    public Node createNodeInstance() {
        return new NodeImpl();
    }

    public PortalACL getPortalACL() {
        return this.portalACL_;
    }

    public List getPredefinedTemplates(String owner) {
        ArrayList<Page> list = new ArrayList<Page>(this.predefinedTemplates_.size());
        for (Page page : this.predefinedTemplates_.values()) {
            if (!owner.equals(page.getOwner())) continue;
            list.add(page);
        }
        return list;
    }

    public Page getPredefinedTemplate(String owner, String name) throws Exception {
        Page page = (Page)this.predefinedTemplates_.get(owner + ":" + name);
        if (page != null) {
            page = (Page)page.softCloneObject();
        }
        return page;
    }

    public void onModifiedOwner(String owner) throws Exception {
        this.portalConfigCache_.remove((Serializable)((Object)owner));
        this.pageConfigCache_.clearCache();
        this.nodeNavigationCache_.clearCache();
    }

    public void onModifiedGroup(String groupId) throws Exception {
        this.portalConfigCache_.clearCache();
        this.pageConfigCache_.clearCache();
        this.nodeNavigationCache_.clearCache();
    }

    public static Object unmarshall(InputStream is, Class type) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory((Class)type);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return uctx.unmarshalDocument(is, null);
    }

    public static void marshall(OutputStream os, Object obj) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        mctx.marshalDocument(obj, "UTF-8", null, os);
    }

    public static String toXML(Object object) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PortalConfigServiceImpl.marshall(os, object);
        return new String(os.toByteArray());
    }

    public static Object fromXML(String xml, Class type) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        return PortalConfigServiceImpl.unmarshall(is, type);
    }
}

