/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl.converter.v11tov2;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.portal.config.impl.converter.v11tov2.ObjectConverter;
import org.exoplatform.portal.config.impl.converter.v11tov2.PortalLayoutConverter;
import org.exoplatform.portal.config.impl.converter.v11tov2.V101ToV2Field;
import org.exoplatform.portal.config.model.Body;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Portlet;
import org.exoplatform.services.backup.XMLObjectConverter;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLField;
import org.exoplatform.xml.object.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V11XMLObjectConverter
extends XMLObjectConverter {
    static String PORTAL_CONFIG_TYPE = PortalConfig.class.getName().intern();
    static String BODY_TYPE = Body.class.getName().intern();
    static String PAGE_TYPE = Page.class.getName().intern();
    static String CONTAINER_TYPE = Container.class.getName().intern();
    static String PORTLET_TYPE = Portlet.class.getName().intern();
    static String PAGE_NODE_TYPE = PageNode.class.getName().intern();
    private List<V101ToV2Field> portletConvertConfiguration;
    private List<V101ToV2Field> containerConvertConfiguration;
    private List<V101ToV2Field> bodyConvertConfiguration;
    private List<V101ToV2Field> pageConvertConfiguration;
    private List<V101ToV2Field> pageNodeConvertConfiguration;
    private List<V101ToV2Field> portalConvertConfiguration = this.getConvertConfiguration("portal-v101-to-v2.xml");

    public V11XMLObjectConverter() {
        this.portletConvertConfiguration = this.getConvertConfiguration("portlets-v101-to-v2.xml");
        this.containerConvertConfiguration = this.getConvertConfiguration("container-v101-to-v2.xml");
        this.bodyConvertConfiguration = this.getConvertConfiguration("body-v101-to-v2.xml");
        this.pageConvertConfiguration = this.getConvertConfiguration("page-v101-to-v2.xml");
        this.pageNodeConvertConfiguration = this.getConvertConfiguration("pagenode-v101-to-v2.xml");
    }

    public void update(XMLObject xmlobject) {
        try {
            String type = xmlobject.getType();
            if (PORTAL_CONFIG_TYPE.equals(type)) {
                for (int i = 0; i < this.portalConvertConfiguration.size(); ++i) {
                    this.setField(xmlobject, this.portalConvertConfiguration.get(i));
                }
            } else if (BODY_TYPE.equals(type)) {
                for (int i = 0; i < this.bodyConvertConfiguration.size(); ++i) {
                    this.setField(xmlobject, this.bodyConvertConfiguration.get(i));
                }
            } else if (PAGE_TYPE.equals(type)) {
                for (int i = 0; i < this.pageConvertConfiguration.size(); ++i) {
                    this.setField(xmlobject, this.pageConvertConfiguration.get(i));
                }
            } else if (CONTAINER_TYPE.equals(type)) {
                for (int i = 0; i < this.containerConvertConfiguration.size(); ++i) {
                    this.setField(xmlobject, this.containerConvertConfiguration.get(i));
                }
            } else if (PORTLET_TYPE.equals(type)) {
                for (int i = 0; i < this.portletConvertConfiguration.size() - 1; ++i) {
                    V101ToV2Field field = this.portletConvertConfiguration.get(i);
                    if (String.valueOf(xmlobject.getFieldValue("windowId")).indexOf(String.valueOf(field.getOldValue())) <= -1) continue;
                    this.convertPortlet(xmlobject, field);
                    return;
                }
                this.convertPortlet(xmlobject, this.portletConvertConfiguration.get(this.portletConvertConfiguration.size() - 1));
            } else if (PAGE_NODE_TYPE.equals(type)) {
                for (int i = 0; i < this.pageNodeConvertConfiguration.size(); ++i) {
                    this.setField(xmlobject, this.pageNodeConvertConfiguration.get(i));
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void pack(XMLObject xmlobject) {
        if (PORTAL_CONFIG_TYPE.equals(xmlobject.getType())) {
            PortalLayoutConverter p = new PortalLayoutConverter();
            try {
                p.update(xmlobject, null, null, null);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    private void convertPortlet(XMLObject xmlobject, V101ToV2Field field) throws Exception {
        this.setField(xmlobject, "windowId", "#" + field.getOldValue(), field.getNewValue());
        List<V101ToV2Field> children = field.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            this.setField(xmlobject, children.get(j));
        }
    }

    private void setField(XMLObject xmlobject, V101ToV2Field field) throws Exception {
        if (field.getType() != null) {
            ((ObjectConverter)Class.forName(field.getType()).newInstance()).update(xmlobject, field.getName(), field.getOldValue(), field.getNewValue());
        } else {
            this.setField(xmlobject, field.getName(), field.getOldValue(), field.getNewValue());
        }
    }

    private void setField(XMLObject xml, String name, Object pattern, Object value) throws Exception {
        boolean set = false;
        if (pattern == null) {
            set = true;
        } else if (pattern.toString().startsWith("#")) {
            if (value == null) {
                return;
            }
            String temp = (String)xml.getFieldValue(name);
            value = temp.replaceAll(((String)pattern).substring(1), (String)value);
            set = true;
        } else if (pattern.toString().equals("*") || pattern.toString().equals(String.valueOf(xml.getFieldValue(name)))) {
            set = true;
        } else if (pattern.toString().startsWith("*")) {
            String realValue = (String)xml.getFieldValue(name);
            value = realValue.replaceAll((String)pattern, (String)value);
            set = true;
        }
        if (!set) {
            return;
        }
        xml.removeField(name);
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            XMLField f = new XMLField(name, value.getClass(), value);
            xml.addField(f);
            return;
        }
        xml.addField(name, value.getClass(), value);
    }

    private List<V101ToV2Field> getConvertConfiguration(String name) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream input = cl.getResourceAsStream("conf/portal/" + name);
            XMLCollection config = XMLCollection.getXMLCollection((InputStream)input);
            return (List)config.getCollection();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return new ArrayList<V101ToV2Field>();
        }
    }
}

