/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.monitor;

public class PortletRequestMonitorData {
    private long minRange_;
    private long maxRange_;
    private int actionRequestCounter_;
    private long minActionExecutionTime_;
    private long maxActionExecutionTime_;
    private long sumActionExecutionTime_ = 0L;
    private int renderRequestCounter_;
    private long minRenderExecutionTime_;
    private long maxRenderExecutionTime_;
    private long sumRenderExecutionTime_ = 0L;
    private int cacheHitCounter_;

    public PortletRequestMonitorData(long minRange, long maxRange) {
        this.minRange_ = minRange;
        this.maxRange_ = maxRange;
        this.actionRequestCounter_ = -5;
        this.minActionExecutionTime_ = 0L;
        this.maxActionExecutionTime_ = 0L;
        this.renderRequestCounter_ = -5;
        this.minRenderExecutionTime_ = 0L;
        this.maxRenderExecutionTime_ = 0L;
        this.cacheHitCounter_ = 0;
    }

    public long minRange() {
        return this.minRange_;
    }

    public long maxRange() {
        return this.maxRange_;
    }

    public int getActionRequestCounter() {
        return this.actionRequestCounter_;
    }

    public int getRenderRequestCounter() {
        return this.renderRequestCounter_;
    }

    public int getCacheHitCounter() {
        return this.cacheHitCounter_;
    }

    public long getMinActionExecutionTime() {
        return this.minActionExecutionTime_;
    }

    public long getMinRenderExecutionTime() {
        return this.minRenderExecutionTime_;
    }

    public long getMaxActionExecutionTime() {
        return this.maxActionExecutionTime_;
    }

    public long getMaxRenderExecutionTime() {
        return this.maxRenderExecutionTime_;
    }

    public long getAvgActionExecutionTime() {
        if (this.actionRequestCounter_ <= 0) {
            return 0L;
        }
        return this.sumActionExecutionTime_ / (long)this.actionRequestCounter_;
    }

    public long getAvgRenderExecutionTime() {
        if (this.renderRequestCounter_ <= 0) {
            return 0L;
        }
        return this.sumRenderExecutionTime_ / (long)this.renderRequestCounter_;
    }

    public long sumActionExecutionTime() {
        return this.sumActionExecutionTime_;
    }

    public long sumRenderExecutionTime() {
        return this.sumRenderExecutionTime_;
    }

    public void logActionRequest(long executionTime) {
        ++this.actionRequestCounter_;
        if (this.actionRequestCounter_ > 0) {
            this.sumActionExecutionTime_ += executionTime;
            if (executionTime < this.minActionExecutionTime_) {
                this.minActionExecutionTime_ = executionTime;
            }
            if (executionTime > this.maxActionExecutionTime_) {
                this.maxActionExecutionTime_ = executionTime;
            }
        } else {
            this.minActionExecutionTime_ = executionTime;
            this.maxActionExecutionTime_ = executionTime;
        }
    }

    public void logRenderRequest(long executionTime, boolean cacheHit) {
        ++this.renderRequestCounter_;
        if (this.renderRequestCounter_ > 0) {
            this.sumRenderExecutionTime_ += executionTime;
            if (cacheHit) {
                ++this.cacheHitCounter_;
            }
            if (executionTime < this.minRenderExecutionTime_) {
                this.minRenderExecutionTime_ = executionTime;
            }
            if (executionTime > this.maxRenderExecutionTime_) {
                this.maxRenderExecutionTime_ = executionTime;
            }
        } else {
            this.minRenderExecutionTime_ = executionTime;
            this.maxRenderExecutionTime_ = executionTime;
        }
    }
}

