/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl;

import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.PortletContainerConstants;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.aop.PortletCommandChain;
import org.exoplatform.services.portletcontainer.impl.monitor.PortletContainerMonitorImpl;
import org.exoplatform.services.portletcontainer.impl.monitor.PortletRuntimeDatasImpl;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.ActionRequestImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.ActionResponseImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletAPIObjectFactory;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletRequestImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletSessionImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.RenderRequestImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.RenderResponseImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.bundle.ResourceBundleManager;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.CustomRequestWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.CustomResponseWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.SharedSessionWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.pool.PortletObjectsWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.pool.PortletObjectsWrapperFactory;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.Output;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;

public class PortletApplicationHandler {
    private PortalContext portalContext;
    private int nbInstances = 0;
    private PortletApplicationsHolder holder;
    private PortletContainerConf conf;
    private static Log log_ = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    private PortletContainerMonitorImpl monitor;
    private ResourceBundleManager resourceBundleManager;
    protected ExoContainer cont;

    public PortletApplicationHandler(PortalContext portalContext, PortletApplicationsHolder holder, PortletContainerConf conf, LogService logService, PortletContainerMonitorImpl portletMonitor, ResourceBundleManager manager, ExoContainerContext context) {
        this.portalContext = portalContext;
        this.holder = holder;
        this.conf = conf;
        this.monitor = portletMonitor;
        this.resourceBundleManager = manager;
        this.cont = context.getContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Input input, Output output, PortletWindowInternal windowInfos, boolean isAction) throws PortletContainerException {
        long startTime = System.currentTimeMillis();
        log_.debug((Object)"process() method in PortletApplicationHandler entered");
        PortletObjectsWrapper portletObjectsWrapper = null;
        PortletSessionImp session = null;
        SharedSessionWrapper sharedSession = null;
        CustomRequestWrapper requestWrapper = null;
        CustomResponseWrapper responseWrapper = null;
        PortletRequestImp portletRequest = null;
        PortletResponseImp portletResponse = null;
        String portletAppName = windowInfos.getWindowID().getPortletApplicationName();
        String portletName = windowInfos.getWindowID().getPortletName();
        try {
            ExoContainer manager = this.cont;
            PortletApplicationProxy proxy = (PortletApplicationProxy)manager.getComponentInstance((Object)portletAppName);
            if (!this.holder.isModeSuported(portletAppName, portletName, input.getMarkup(), input.getPortletMode())) {
                throw new PortletContainerException("The portlet mode " + input.getPortletMode().toString() + " is not supported for the " + input.getMarkup() + " markup language.");
            }
            if (!this.holder.isStateSupported(input.getWindowState(), portletAppName)) {
                log_.debug((Object)("Window state : " + input.getWindowState() + " not supported, set the window state to normal"));
                input.setWindowState(WindowState.NORMAL);
            }
            String exception_key = PortletContainerConstants.EXCEPTION + portletAppName + portletName;
            PortletContext portletContext = PortletAPIObjectFactory.getInstance().createPortletContext(this.cont, servletContext);
            log_.debug((Object)"Create new object");
            PortletObjectsWrapperFactory.createInstance(this.cont);
            portletObjectsWrapper = PortletObjectsWrapperFactory.getInstance().createObject();
            if (this.conf.isSharedSessionEnable()) {
                log_.debug((Object)"shared session enable");
                sharedSession = portletObjectsWrapper.getSharedSessionWrapper();
            }
            session = (PortletSessionImp)portletObjectsWrapper.getPortletSession();
            requestWrapper = portletObjectsWrapper.getCustomRequestWrapper();
            responseWrapper = portletObjectsWrapper.getCustomResponseWrapper();
            if (isAction) {
                portletRequest = (ActionRequestImp)portletObjectsWrapper.getActionRequest();
                portletResponse = (ActionResponseImp)portletObjectsWrapper.getActionResponse();
            } else {
                portletRequest = (RenderRequestImp)portletObjectsWrapper.getRenderRequest();
                portletResponse = (RenderResponseImp)portletObjectsWrapper.getRenderResponse();
            }
            long portletAppVersionNumber = 1L;
            portletAppVersionNumber = this.monitor.getPortletVersionNumber(portletAppName);
            log_.debug((Object)("Get portlet version number : " + portletAppVersionNumber));
            if (this.conf.isSharedSessionEnable()) {
                sharedSession.fillSharedSessionWrapper(request.getSession(), portletAppName);
                sharedSession.init();
                session.fillPortletSession(sharedSession, portletContext, windowInfos.getWindowID().getUniqueID());
            } else {
                session.fillPortletSession(request.getSession(), portletContext, windowInfos.getWindowID().getUniqueID());
            }
            requestWrapper.fillCustomRequestWrapper(request, windowInfos.getWindowID().getUniqueID());
            responseWrapper.fillResponseWrapper(response);
            portletRequest.fillPortletRequest((HttpServletRequest)requestWrapper, this.portalContext, portletContext, session, this.holder.getPortletMetaData(portletAppName, portletName), input, windowInfos, this.holder.getPortletApplication(portletAppName).getSecurityConstraint(), this.holder.getPortletApplication(portletAppName).getUserAttribute(), this.holder.getPortletApplication(portletAppName).getCustomPortletMode(), this.holder.getPortletApplication(portletAppName).getCustomWindowState(), this.holder.getRoles(portletAppName), this.conf.getSupportedContent());
            portletRequest.setAttribute("javax.portlet.userinfo", input.getUserAttributes());
            portletResponse.fillPortletResponse((HttpServletResponse)responseWrapper, output, this.holder.getPortletApplication(portletAppName).getCustomWindowState());
            if (isAction) {
                ((ActionResponseImp)portletResponse).fillActionResponse(input, this.holder.getPortletMetaData(portletAppName, portletName));
            } else {
                ((RenderRequestImp)portletRequest).fillRenderRequest(((RenderInput)input).getRenderParameters(), ((RenderInput)input).isUpdateCache());
                ((RenderResponseImp)portletResponse).fillRenderResponse(windowInfos.getWindowID().getUniqueID(), input, this.holder.getPortletMetaData(portletAppName, portletName), request.isSecure(), this.conf.getSupportedContent(), Collections.enumeration(this.holder.getWindowStates(portletAppName)));
            }
            this.monitor.setLastAccessTime(portletAppName, portletName, startTime);
            boolean isBroken = this.monitor.isBroken(portletAppName, portletName);
            boolean isAvailable = this.monitor.isAvailable(portletAppName, portletName, startTime);
            boolean isDestroyed = this.monitor.isDestroyed(portletAppName, portletName);
            if (isDestroyed) {
                log_.debug((Object)"Portlet is destroyed");
                this.generateOutputForException(portletRequest, isAction, null, output);
                return;
            }
            if (isBroken || !isAvailable || portletRequest.getAttribute(exception_key) != null) {
                log_.debug((Object)"Portlet is borken, not available or the request contains an associated error");
                this.generateOutputForException(portletRequest, isAction, exception_key, output);
                return;
            }
            javax.portlet.Portlet portlet = null;
            try {
                portlet = proxy.getPortlet(portletContext, portletName);
            }
            catch (PortletException e) {
                log_.error((Object)("unable to get portlet :  " + portletName), (Throwable)e);
                portletRequest.setAttribute(exception_key, (Object)e);
                this.generateOutputForException(portletRequest, isAction, exception_key, output);
                long endTime = System.currentTimeMillis();
                PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                if (rtd != null) {
                    if (isAction) {
                        rtd.logProcessActionRequest(startTime, endTime);
                    } else {
                        boolean cacheHit = ((RenderOutput)output).isCacheHit();
                        rtd.logRenderRequest(startTime, endTime, cacheHit);
                    }
                }
                return;
            }
            try {
                if (isAction) {
                    PortletCommandChain chain = (PortletCommandChain)this.cont.getComponentInstanceOfType(PortletCommandChain.class);
                    chain.doProcessAction(portlet, (ActionRequest)portletRequest, (ActionResponse)portletResponse);
                    if (((ActionResponseImp)portletResponse).isSendRedirectAlreadyOccured()) {
                        String location = ((ActionResponseImp)portletResponse).getLocation();
                        log_.debug((Object)("need to redirect to " + location));
                        output.addProperty("_send_redirect_", (Object)location);
                    }
                } else {
                    PortletCommandChain chain = (PortletCommandChain)this.cont.getComponentInstanceOfType(PortletCommandChain.class);
                    chain.doRender(portlet, (RenderRequest)portletRequest, (RenderResponse)portletResponse);
                    if (((RenderInput)input).getTitle() != null) {
                        log_.debug((Object)"overide default title");
                        ((RenderOutput)output).setTitle(((RenderInput)input).getTitle());
                    }
                }
            }
            catch (Throwable t) {
                block47: {
                    log_.error((Object)"exception returned by processAction() or render() methods", t);
                    this.monitor.setLastFailureAccessTime(portletAppName, portletName, startTime);
                    if (t instanceof RuntimeException) {
                        log_.debug((Object)"It is a runtime exception");
                        portletRequest.setAttribute(exception_key, t);
                        this.generateOutputForException(portletRequest, isAction, exception_key, output);
                        long endTime = System.currentTimeMillis();
                        PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                        if (rtd != null) {
                            if (isAction) {
                                rtd.logProcessActionRequest(startTime, endTime);
                            } else {
                                boolean cacheHit = ((RenderOutput)output).isCacheHit();
                                rtd.logRenderRequest(startTime, endTime, cacheHit);
                            }
                        }
                        return;
                    }
                    if (!(t instanceof PortletException)) break block47;
                    log_.debug((Object)"It is a portlet exception");
                    PortletException e = (PortletException)t;
                    if (t instanceof UnavailableException) {
                        log_.debug((Object)"It is an unavailable exception");
                        UnavailableException ex = (UnavailableException)e;
                        if (!ex.isPermanent()) {
                            log_.debug((Object)"but a non permanent one");
                            this.monitor.setUnavailabilityPeriod(portletAppName, portletName, ex.getUnavailableSeconds());
                        } else {
                            log_.debug((Object)"a permanent one, so destroy the portlet and broke it");
                            proxy.destroy(portletName);
                            this.monitor.brokePortlet(portletAppName, portletName);
                        }
                    }
                    portletRequest.setAttribute(exception_key, (Object)e);
                    this.generateOutputForException(portletRequest, isAction, exception_key, output);
                    long endTime = System.currentTimeMillis();
                    PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                    if (rtd != null) {
                        if (isAction) {
                            rtd.logProcessActionRequest(startTime, endTime);
                        } else {
                            boolean cacheHit = ((RenderOutput)output).isCacheHit();
                            rtd.logRenderRequest(startTime, endTime, cacheHit);
                        }
                    }
                    return;
                }
                log_.debug((Object)"It is not a portlet exception");
                portletRequest.setAttribute(exception_key, t);
                this.generateOutputForException(portletRequest, isAction, exception_key, output);
                long endTime = System.currentTimeMillis();
                PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                if (rtd != null) {
                    if (isAction) {
                        rtd.logProcessActionRequest(startTime, endTime);
                    } else {
                        boolean cacheHit = ((RenderOutput)output).isCacheHit();
                        rtd.logRenderRequest(startTime, endTime, cacheHit);
                    }
                }
                return;
            }
        }
        finally {
            long endTime = System.currentTimeMillis();
            PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
            if (rtd != null) {
                if (isAction) {
                    rtd.logProcessActionRequest(startTime, endTime);
                } else {
                    boolean cacheHit = ((RenderOutput)output).isCacheHit();
                    rtd.logRenderRequest(startTime, endTime, cacheHit);
                }
            }
        }
    }

    private void generateOutputForException(PortletRequestImp request, boolean isAction, String key, Output output) {
        String prop_key = "";
        String prop_output = "";
        String title = "";
        String content = "";
        log_.debug((Object)"generate the exception message");
        if (key == null) {
            prop_key = PortletContainerConstants.DESTROYED;
            prop_output = "output generated because of a destroyed portlet access";
            title = "Portlet destroyed";
            content = "Portlet unvailable";
        } else {
            Throwable e = (Throwable)request.getAttribute(key);
            prop_key = PortletContainerConstants.EXCEPTION;
            prop_output = "output generated because of an exception";
            title = "Exception occured";
            if (e != null) {
                log_.debug((Object)("Exception associated : " + e.toString()));
                content = e.toString();
                while (e.getCause() != null) {
                    e = e.getCause();
                    String ce = "Cause: " + e.toString();
                    if (content == null) {
                        content = ce;
                        continue;
                    }
                    content = content + "<br>" + ce;
                }
                if (content == null) {
                    content = prop_output;
                }
                prop_output = content;
            } else {
                log_.debug((Object)"No exception associated");
                content = "There is a problem";
            }
        }
        if (isAction) {
            output.addProperty(prop_key, (Object)prop_output);
        } else {
            ((RenderOutput)output).setTitle(title);
            ((RenderOutput)output).setContent(content.toCharArray());
            output.addProperty(prop_key, (Object)prop_output);
        }
    }

    public ResourceBundle getBundle(String portletAppName, String portletName, Locale locale) {
        Portlet type = this.holder.getPortletMetaData(portletAppName, portletName);
        try {
            return this.resourceBundleManager.lookupBundle(type, locale);
        }
        catch (Exception e) {
            return null;
        }
    }
}

