/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.PortletApplicationRegister;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletLifecycleListener;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.pci.model.Filter;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;

public class PortletApplicationRegisterImpl
implements PortletApplicationRegister {
    private Collection listeners_;
    private LogService logService_;
    private Log log;
    private PortletApplicationsHolder holder_;
    protected ExoContainer cont;
    protected ExoContainer appcont;

    public PortletApplicationRegisterImpl(ExoContainerContext context, PortletApplicationsHolder holder, LogService logService) {
        this.logService_ = logService;
        this.listeners_ = new ArrayList();
        this.holder_ = holder;
        this.log = this.logService_.getLog(this.getClass());
        this.cont = context.getContainer();
        this.appcont = ExoContainerContext.getTopContainer();
    }

    public void addListenerPlugin(ComponentPlugin listener) {
        if (!(listener instanceof PortletLifecycleListener)) {
            throw new RuntimeException("Expect listener of type PortletLifecycleListener");
        }
        this.listeners_.add(listener);
    }

    public ComponentPlugin removeListener(String name) {
        return null;
    }

    public Collection getListeners() {
        return this.listeners_;
    }

    public void registerPortletApplication(ServletContext servletContext, PortletApp portletApp_, Collection roles) throws PortletContainerException {
        String portletAppName = servletContext.getServletContextName();
        this.log.debug((Object)("send pre deploy event for portlet app : " + servletContext.getServletContextName()));
        for (PortletLifecycleListener portletLifecycleListener : this.listeners_) {
            portletLifecycleListener.preDeploy(portletAppName, portletApp_, servletContext);
        }
        this.holder_.registerPortletApplication(portletAppName, portletApp_, roles);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            this.appcont.registerComponentImplementation((Object)portletAppName, cl.loadClass("org.exoplatform.services.portletcontainer.impl.PortletApplicationProxy"));
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"Class not found", (Throwable)e);
            throw new PortletContainerException("Class not found", (Throwable)e);
        }
        PortletApplicationProxy proxy = (PortletApplicationProxy)this.appcont.getComponentInstance((Object)portletAppName);
        proxy.setApplicationName(portletAppName);
        proxy.load();
        this.log.debug((Object)"send post deploy event");
        for (PortletLifecycleListener portletLifecycleListener : this.listeners_) {
            portletLifecycleListener.postDeploy(portletAppName, portletApp_, servletContext);
        }
    }

    public void removePortletApplication(ServletContext servletContext) throws PortletContainerException {
        PortletApp portletApp = this.holder_.getPortletApplication(servletContext.getServletContextName());
        if (portletApp == null) {
            return;
        }
        String portletAppName = servletContext.getServletContextName();
        this.log.debug((Object)"send pre undeploy event");
        for (PortletLifecycleListener portletLifecycleListener : this.listeners_) {
            portletLifecycleListener.preUndeploy(portletAppName, portletApp, servletContext);
        }
        this.appcont.unregisterComponent((Object)portletAppName);
        this.removeFilters(portletAppName, portletApp);
        this.holder_.removePortletApplication(portletAppName);
        this.log.debug((Object)"send post undeploy event");
        for (PortletLifecycleListener portletLifecycleListener : this.listeners_) {
            portletLifecycleListener.postUndeploy(portletAppName, portletApp, servletContext);
        }
    }

    private void removeFilters(String portletAppName, PortletApp portletApp) {
        this.log.debug((Object)"remove filters entered");
        List portlets = portletApp.getPortlet();
        for (Portlet portlet : portlets) {
            List filters = portlet.getFilter();
            for (Filter portletFilterData : filters) {
                String key = portletAppName + "_filter_" + portletFilterData.getFilterName();
                this.appcont.unregisterComponent((Object)key);
            }
        }
    }
}

