/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.impl.PortletDataImp;
import org.exoplatform.services.portletcontainer.pci.model.CustomWindowState;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.UserDataConstraint;

public class PortletApplicationsHolder {
    private Map portletApps = new HashMap();
    private Log log;

    public PortletApplicationsHolder(LogService logService) {
        this.log = logService.getLog("org.exoplatform.services.portletcontainer");
    }

    public void start() {
    }

    public void stop() {
    }

    public PortletApp getPortletApplication(String portletAppName) {
        PortletApplicationHelper helper = (PortletApplicationHelper)this.portletApps.get(portletAppName);
        if (helper == null) {
            this.log.debug((Object)("Portlet application : " + portletAppName + " does not exist"));
            return null;
        }
        return helper.getPortletApp();
    }

    public Collection getRoles(String portletAppName) {
        this.log.debug((Object)"getRoles() entered");
        PortletApplicationHelper helper = (PortletApplicationHelper)this.portletApps.get(portletAppName);
        return helper.getRoles();
    }

    public Map getAllPortletMetaData(ExoContainer container) {
        this.log.debug((Object)"getAllPortletMetaData() entered");
        HashMap<String, PortletDataImp> all = new HashMap<String, PortletDataImp>(20);
        Set applicationsKeys = this.portletApps.keySet();
        for (String key : applicationsKeys) {
            PortletApplicationHelper helper = (PortletApplicationHelper)this.portletApps.get(key);
            PortletApp pA = helper.getPortletApp();
            List securityContraints = pA.getSecurityConstraint();
            List portlets = pA.getPortlet();
            UserDataConstraint userDataConstraintType = null;
            for (int i = 0; i < portlets.size(); ++i) {
                Portlet portlet = (Portlet)portlets.get(i);
                block2: for (SecurityConstraint element : securityContraints) {
                    List portletsList = element.getPortletCollection().getPortletName();
                    for (String name : portletsList) {
                        if (!name.equals(portlet.getPortletName())) continue;
                        userDataConstraintType = element.getUserDataConstraint();
                        continue block2;
                    }
                }
                all.put(key + "/" + portlet.getPortletName(), new PortletDataImp(container, portlet, userDataConstraintType, pA.getUserAttribute()));
            }
        }
        return all;
    }

    public Collection getPortletModes(String portletAppName, String portletName, String markup) {
        this.log.debug((Object)"getPortletModes() entered");
        ArrayList<PortletMode> modes = new ArrayList<PortletMode>();
        List portlets = this.getPortletApplication(portletAppName).getPortlet();
        for (Portlet portlet : portlets) {
            if (!portlet.getPortletName().equals(portletName)) continue;
            List l = portlet.getSupports();
            for (Supports supports : l) {
                String mimeType = supports.getMimeType();
                if (!mimeType.equals(markup)) continue;
                List modesR = supports.getPortletMode();
                for (String s : modesR) {
                    modes.add(new PortletMode(s));
                }
            }
        }
        return modes;
    }

    public boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        this.log.debug((Object)"isModeSuported() entered");
        if (PortletMode.VIEW == mode) {
            return true;
        }
        Collection modesSupported = this.getPortletModes(portletAppName, portletName, markup);
        for (PortletMode portletMode : modesSupported) {
            if (!portletMode.toString().equals(mode.toString())) continue;
            return true;
        }
        return false;
    }

    public Collection getWindowStates(String portletAppName) {
        this.log.debug((Object)"getWindowStates() entered");
        ArrayList<WindowState> states = new ArrayList<WindowState>();
        states.add(WindowState.MINIMIZED);
        states.add(WindowState.NORMAL);
        states.add(WindowState.MAXIMIZED);
        List customStates = this.getPortletApplication(portletAppName).getCustomWindowState();
        for (CustomWindowState customWindowState : customStates) {
            WindowState state = new WindowState(customWindowState.getWindowState());
            states.add(state);
        }
        return states;
    }

    public boolean isStateSupported(WindowState state, String portletApplication) {
        this.log.debug((Object)"isStateSupported() entered");
        Collection c = this.getWindowStates(portletApplication);
        for (WindowState windowState : c) {
            if (!windowState.toString().equals(state.toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortletApplication(String portletAppName, PortletApp portletApp, Collection roles) {
        PortletApplicationHelper helper = new PortletApplicationHelper(portletAppName, portletApp, roles);
        Map map = this.portletApps;
        synchronized (map) {
            this.portletApps.put(portletAppName, helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortletApplication(String portletAppName) {
        Map map = this.portletApps;
        synchronized (map) {
            this.portletApps.remove(portletAppName);
        }
    }

    public Portlet getPortletMetaData(String portletApplication, String portlet) {
        this.log.debug((Object)"getPortletMetaData() entered");
        PortletApp portletApp = this.getPortletApplication(portletApplication);
        if (portletApp == null) {
            return null;
        }
        List l = portletApp.getPortlet();
        for (Portlet portlet1 : l) {
            if (!portlet1.getPortletName().equals(portlet)) continue;
            return portlet1;
        }
        return null;
    }

    private class PortletApplicationHelper {
        private PortletApp portletApp;
        private Collection roles;
        private String portletAppName;

        public PortletApplicationHelper(String portletAppName, PortletApp portletApp, Collection roles) {
            this.portletApp = portletApp;
            this.roles = roles;
            this.portletAppName = portletAppName;
        }

        public PortletApp getPortletApp() {
            return this.portletApp;
        }

        public Collection getRoles() {
            return this.roles;
        }
    }
}

