/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.aop;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.aop.ActionExecutionContext;
import org.exoplatform.services.portletcontainer.impl.aop.BaseCommandUnit;
import org.exoplatform.services.portletcontainer.impl.aop.RenderExecutionContext;
import org.exoplatform.services.portletcontainer.impl.monitor.PortletContainerMonitorImpl;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.ActionRequestImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.RenderRequestImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.RenderResponseImp;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;

public class PortletCacheCommand
extends BaseCommandUnit {
    private PortletContainerConf conf;
    private PortletContainerMonitorImpl portletMonitor;

    public PortletCacheCommand(PortletContainerConf conf, PortletContainerMonitorImpl monitor) {
        this.conf = conf;
        this.portletMonitor = monitor;
    }

    protected Object render(RenderExecutionContext rcontext) throws Throwable {
        if (!this.conf.isCacheEnable()) {
            return rcontext.executeNextUnit();
        }
        this.log_.debug((Object)"--> render method, call cache interceptor");
        RenderRequestImp req = (RenderRequestImp)rcontext.request_;
        RenderResponseImp res = (RenderResponseImp)rcontext.response_;
        if (req.getPortletDatas().getExpirationCache() == null) {
            return rcontext.executeNextUnit();
        }
        String portletAppName = req.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        String portletName = req.getPortletWindowInternal().getWindowID().getPortletName();
        String uniqueId = req.getPortletWindowInternal().getWindowID().getUniqueID();
        PortletMode mode = req.getPortletMode();
        WindowState window = req.getWindowState();
        boolean isCacheGlobal = this.resolveCache(req.getPortletDatas().getGlobalCache());
        this.log_.debug((Object)("Is cache global: " + isCacheGlobal));
        String key = null;
        key = isCacheGlobal ? req.getInput().getWindowID().getOwner() + uniqueId : req.getSession().getId() + req.getRemoteUser() + req.getInput().getWindowID().getOwner() + uniqueId;
        if (req.isRenderRequest()) {
            rcontext.executeNextUnit();
            this.updateCache(portletAppName, portletName, key, res, mode, window, isCacheGlobal);
            return null;
        }
        if (this.portletMonitor.needsCacheInvalidation(portletAppName, portletName, key, mode, window, isCacheGlobal)) {
            this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        }
        int expirationPeriod = this.portletMonitor.getCacheExpirationPeriod(portletAppName, portletName);
        long lastAccessTime = this.portletMonitor.getPortletLastAccessTime(portletAppName, portletName, key, isCacheGlobal);
        long currentAccessTime = System.currentTimeMillis();
        if (expirationPeriod == 0) {
            this.log_.debug((Object)"Expiration period 0 before proceed");
            rcontext.executeNextUnit();
            this.log_.debug((Object)"Expiration period 0 after proceed");
        } else if (expirationPeriod == -1) {
            if (this.portletMonitor.isDataCached(portletAppName, portletName, key, isCacheGlobal)) {
                this.log_.debug((Object)"Use cache : Expiration period -1 data already cached");
                ((RenderOutput)res.getOutput()).setContent(this.portletMonitor.getCachedContent(portletAppName, portletName, key, isCacheGlobal));
                ((RenderOutput)res.getOutput()).setTitle(this.portletMonitor.getCachedTitle(portletAppName, portletName, key, isCacheGlobal));
            } else {
                this.log_.debug((Object)"Expiration period -1 data first cached, before proceed");
                rcontext.executeNextUnit();
                this.log_.debug((Object)"Expiration period -1 data first cached, after proceed");
                this.updateCache(portletAppName, portletName, key, res, mode, window, isCacheGlobal);
            }
        } else if (currentAccessTime - lastAccessTime > (long)(expirationPeriod * 1000)) {
            this.log_.debug((Object)"Expiration period currentAccessTime - lastAccessTime > expirationPeriod * 1000 before proceed");
            rcontext.executeNextUnit();
            this.log_.debug((Object)"Expiration period currentAccessTime - lastAccessTime > expirationPeriod * 1000 after proceed");
            this.updateCache(portletAppName, portletName, key, res, mode, window, isCacheGlobal);
        } else if (0L < currentAccessTime - lastAccessTime && currentAccessTime - lastAccessTime < (long)(expirationPeriod * 1000)) {
            this.log_.debug((Object)"Use cache : currentAccessTime - lastAccessTime < expirationPeriod * 1000");
            ((RenderOutput)res.getOutput()).setContent(this.portletMonitor.getCachedContent(portletAppName, portletName, key, isCacheGlobal));
            ((RenderOutput)res.getOutput()).setTitle(this.portletMonitor.getCachedTitle(portletAppName, portletName, key, isCacheGlobal));
        }
        return null;
    }

    protected Object processAction(ActionExecutionContext acontext) throws Throwable {
        if (!this.conf.isCacheEnable()) {
            return acontext.executeNextUnit();
        }
        this.log_.debug((Object)"--> processAction method, call cache interceptor");
        ActionRequestImp req = (ActionRequestImp)acontext.request_;
        if (req.getPortletDatas().getExpirationCache() == null) {
            return acontext.executeNextUnit();
        }
        boolean isCacheGlobal = this.resolveCache(req.getPortletDatas().getGlobalCache());
        this.log_.debug((Object)("Is cache global: " + isCacheGlobal));
        String portletAppName = req.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        String portletName = req.getPortletWindowInternal().getWindowID().getPortletName();
        String uniqueID = req.getPortletWindowInternal().getWindowID().getUniqueID();
        String key = req.getSession().getId() + req.getRemoteUser() + req.getInput().getWindowID().getOwner() + uniqueID;
        this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        return acontext.executeNextUnit();
    }

    private void updateCache(String portletAppName, String portletName, String key, PortletResponseImp response, PortletMode mode, WindowState window, boolean isCacheGlobal) {
        this.log_.debug((Object)"Update cache");
        this.portletMonitor.setCachedTitle(portletAppName, portletName, key, ((RenderOutput)response.getOutput()).getTitle(), isCacheGlobal);
        this.portletMonitor.setCachedContent(portletAppName, portletName, key, ((RenderOutput)response.getOutput()).getContent(), isCacheGlobal);
        this.portletMonitor.setCachedMode(portletAppName, portletName, key, mode, isCacheGlobal);
        this.portletMonitor.setCachedWindowState(portletAppName, portletName, key, window, isCacheGlobal);
        String s = (String)response.getOutput().getProperties().get("portlet.expiration-cache");
        if (s != null) {
            int i = Integer.parseInt(s);
            this.portletMonitor.setCacheExpirationPeriod(portletAppName, portletName, i);
        }
        this.portletMonitor.setPortletLastAccessTime(portletAppName, portletName, key, System.currentTimeMillis(), isCacheGlobal);
    }

    private boolean resolveCache(String s) {
        if (s == null) {
            return false;
        }
        return "true".equals(s);
    }
}

