/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.exoplatform.commons.xml.ExoXMLSerializer;
import org.exoplatform.services.portletcontainer.impl.config.Cache;
import org.exoplatform.services.portletcontainer.impl.config.CustomMode;
import org.exoplatform.services.portletcontainer.impl.config.CustomWindowState;
import org.exoplatform.services.portletcontainer.impl.config.Description;
import org.exoplatform.services.portletcontainer.impl.config.Global;
import org.exoplatform.services.portletcontainer.impl.config.PortletContainer;
import org.exoplatform.services.portletcontainer.impl.config.Properties;
import org.exoplatform.services.portletcontainer.impl.config.SupportedContent;

public class XMLSerializer {
    private static String NS = "";

    public static void toXML(ExoXMLSerializer ser, PortletContainer pc) throws Exception {
        int i;
        ser.startTag(NS, "global");
        XMLSerializer.toXML(ser, pc.getGlobal());
        ser.endTag(NS, "global");
        ser.startTag(NS, "cache");
        XMLSerializer.toXML(ser, pc.getCache());
        ser.endTag(NS, "cache");
        List list = pc.getSupportedContent();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(NS, "supported-content");
            ser.element(NS, "name", ((SupportedContent)list.get(i)).getName());
            ser.endTag(NS, "supported-content");
        }
        list = pc.getCustomMode();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(NS, "custom-mode");
            XMLSerializer.toXML(ser, (CustomMode)list.get(i));
            ser.endTag(NS, "custom-mode");
        }
        list = pc.getCustomWindowState();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(NS, "custom-window-state");
            XMLSerializer.toXML(ser, (CustomWindowState)list.get(i));
            ser.endTag(NS, "custom-window-state");
        }
        list = pc.getProperties();
        for (i = 0; i < list.size(); ++i) {
            ser.startTag(NS, "properties");
            XMLSerializer.toXML(ser, (Properties)list.get(i));
            ser.endTag(NS, "properties");
        }
    }

    public static void toXML(ExoXMLSerializer ser, Global global) throws Exception {
        ser.element(NS, "name", global.getName());
        ser.element(NS, "description", global.getDescription());
        ser.element(NS, "major-version", Integer.toString(global.getMajorVersion()));
        ser.element(NS, "minor-version", Integer.toString(global.getMinorVersion()));
    }

    public static void toXML(ExoXMLSerializer ser, Cache cache) throws Exception {
        ser.element(NS, "enable", cache.getEnable());
    }

    public static void toXML(ExoXMLSerializer ser, CustomMode mode) throws Exception {
        ser.element(NS, "name", mode.getName());
        List descs = mode.getDescription();
        for (int i = 0; i < descs.size(); ++i) {
            XMLSerializer.toXML(ser, (Description)descs.get(i));
        }
    }

    public static void toXML(ExoXMLSerializer ser, CustomWindowState state) throws Exception {
        ser.element(NS, "name", state.getName());
        List descs = state.getDescription();
        for (int i = 0; i < descs.size(); ++i) {
            XMLSerializer.toXML(ser, (Description)descs.get(i));
        }
    }

    public static void toXML(ExoXMLSerializer ser, Properties props) throws Exception {
        ser.element(NS, "description", props.getName());
        ser.element(NS, "name", props.getName());
        ser.element(NS, "value", props.getValue());
    }

    public static void toXML(ExoXMLSerializer ser, Description desc) throws Exception {
        ser.startTag(NS, "description");
        ser.attribute(NS, "lang", desc.getLang());
        ser.text(desc.getDescription());
        ser.endTag(NS, "description");
    }

    public static String toXML(PortletContainer pc) throws Exception {
        ExoXMLSerializer ser = ExoXMLSerializer.getInstance();
        StringWriter sw = new StringWriter();
        ser.setOutput((Writer)sw);
        ser.startDocument("UTF-8", null);
        ser.text("\n");
        ser.startTag(NS, "portlet-container");
        XMLSerializer.toXML(ser, pc);
        ser.endTag(NS, "portlet-container");
        ser.endDocument();
        return sw.getBuffer().toString();
    }
}

