/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.monitor;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.portletcontainer.monitor.CachedData;
import org.exoplatform.services.portletcontainer.monitor.PortletRequestMonitorData;
import org.exoplatform.services.portletcontainer.monitor.PortletRuntimeData;

public class PortletRuntimeDatasImpl
implements PortletRuntimeData {
    static int NUMBER_OF_REQUEST_MONITOR = 10;
    static long TIME_RANGE = 100L;
    private String portletAppName;
    private String portletName;
    private boolean initialized;
    private long initializationTime;
    private long lastAccessTime;
    private long lastFailureAccessTime;
    private long lastInitFailureAccessTime;
    private long unavailabilityPeriod = 0L;
    private int cacheExpirationPeriod = 0;
    private String globalKey;
    private ExoCache userCache;
    private Log log;
    private ExoCache globalCache;
    private PortletRequestMonitorData[] portletRequestMonitors_;

    public PortletRuntimeDatasImpl(String portletAppName, String portletName, CacheService cacheService, ExoCache globalCache, Log log) {
        this.log = log;
        this.globalCache = globalCache;
        this.portletAppName = portletAppName;
        this.portletName = portletName;
        this.globalKey = portletAppName + "/" + portletName;
        try {
            this.userCache = cacheService.getCacheInstance(this.globalKey);
        }
        catch (Exception e) {
            log.error((Object)"Can not lookup user cache", (Throwable)e);
        }
        this.portletRequestMonitors_ = new PortletRequestMonitorData[NUMBER_OF_REQUEST_MONITOR];
        long min = 0L;
        long max = TIME_RANGE - 1L;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            this.portletRequestMonitors_[i] = new PortletRequestMonitorData(min, max);
            min += TIME_RANGE;
            max += TIME_RANGE;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void setInitialized(boolean b) {
        this.initialized = b;
    }

    public String getPortletAppName() {
        return this.portletAppName;
    }

    public synchronized void setPortletAppName(String s) {
        this.portletAppName = s;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public synchronized void setPortletName(String s) {
        this.portletName = s;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public synchronized void setLastAccessTime(long l) {
        this.lastAccessTime = l;
    }

    public long getLastFailureAccessTime() {
        return this.lastFailureAccessTime;
    }

    public long getLastInitFailureAccessTime() {
        return this.lastInitFailureAccessTime;
    }

    public synchronized void setLastInitFailureAccessTime(long l) {
        this.lastInitFailureAccessTime = l;
    }

    public synchronized void setLastFailureAccessTime(long l) {
        this.lastFailureAccessTime = l;
    }

    public long getUnavailabilityPeriod() {
        return this.unavailabilityPeriod;
    }

    public synchronized void setUnavailabilityPeriod(long l) {
        this.unavailabilityPeriod = l;
    }

    public boolean isDataCached(String key, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal ? this.globalCache.get((Serializable)((Object)key)) != null : this.userCache.get((Serializable)((Object)key)) != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load data from user cache", (Throwable)e);
        }
        return false;
    }

    public synchronized void setCachedData(String key, CachedData cachedData, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal) {
                this.globalCache.put((Serializable)((Object)key), (Object)cachedData);
            } else {
                this.userCache.put((Serializable)((Object)key), (Object)cachedData);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to store data in user cache", (Throwable)e);
        }
    }

    public CachedData getCachedData(String key, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal) {
                return (CachedData)this.globalCache.get((Serializable)((Object)key));
            }
            return (CachedData)this.userCache.get((Serializable)((Object)key));
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load data from user cache", (Throwable)e);
            return null;
        }
    }

    public synchronized void removeCachedData(String key, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal) {
                this.globalCache.remove((Serializable)((Object)key));
            } else {
                this.userCache.remove((Serializable)((Object)key));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to remove data from user cache", (Throwable)e);
        }
    }

    public int getCacheExpirationPeriod() {
        return this.cacheExpirationPeriod;
    }

    public synchronized void setCacheExpirationPeriod(int t) {
        this.cacheExpirationPeriod = t;
    }

    public long getInitializationTime() {
        return this.initializationTime;
    }

    public synchronized void setInitializationTime(long l) {
        this.initializationTime = l;
    }

    public final void logProcessActionRequest(long startTime, long endTime) {
        long executionTime = endTime - startTime;
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        this.portletRequestMonitors_[index].logActionRequest(executionTime);
    }

    public final void logRenderRequest(long startTime, long endTime, boolean cacheHit) {
        long executionTime = endTime - startTime;
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        this.portletRequestMonitors_[index].logRenderRequest(executionTime, cacheHit);
    }

    public PortletRequestMonitorData[] getPortletRequestMonitorData() {
        return this.portletRequestMonitors_;
    }

    public synchronized boolean isAvailable(long l) {
        if (l - this.getLastFailureAccessTime() > this.getUnavailabilityPeriod()) {
            this.setUnavailabilityPeriod(0L);
            return true;
        }
        return false;
    }

    public synchronized boolean isInitialisationAllowed(long l) {
        if (l - this.getLastInitFailureAccessTime() > this.getUnavailabilityPeriod()) {
            this.setUnavailabilityPeriod(0L);
            return true;
        }
        return false;
    }

    public long whenAvailable() {
        long period = this.getUnavailabilityPeriod() - (System.currentTimeMillis() - this.getLastInitFailureAccessTime());
        if (period < 0L) {
            return -1L;
        }
        return period;
    }
}

