/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletSessionImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.RenderRequestImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.CustomRequestWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.CustomResponseWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.NestedResponseWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.pool.EmptyResponse;

public class PortletRequestDispatcherImp
implements PortletRequestDispatcher {
    private String path;
    private RequestDispatcher dispatcher;
    private Log log;
    protected ExoContainer cont;

    public PortletRequestDispatcherImp(ExoContainer cont, RequestDispatcher dispatcher, String path) {
        this.dispatcher = dispatcher;
        this.path = path;
        this.cont = cont;
        this.log = ((LogService)cont.getComponentInstanceOfType(LogService.class)).getLog("org.exoplatform.services.portletcontainer");
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        CustomRequestWrapper requestWrapper = null;
        PortletContainerConf conf = (PortletContainerConf)this.cont.getComponentInstanceOfType(PortletContainerConf.class);
        boolean isSharedSessionEnable = conf.isSharedSessionEnable();
        try {
            char[] ca;
            requestWrapper = (CustomRequestWrapper)((HttpServletRequestWrapper)request).getRequest();
            CustomResponseWrapper realResponseWrapper = (CustomResponseWrapper)((HttpServletResponseWrapper)response).getResponse();
            NestedResponseWrapper responseWrapper = new NestedResponseWrapper(new EmptyResponse());
            responseWrapper.fillResponseWrapper((HttpServletResponse)realResponseWrapper);
            request.setAttribute("javax.portlet.config", (Object)((RenderRequestImp)request).getPortletConfig());
            request.setAttribute("javax.portlet.request", (Object)request);
            request.setAttribute("javax.portlet.response", (Object)response);
            responseWrapper.flushBuffer();
            requestWrapper.setRedirected(true);
            requestWrapper.setRedirectedPath(this.path);
            if (isSharedSessionEnable) {
                PortletSessionImp pS = (PortletSessionImp)request.getPortletSession();
                requestWrapper.setSharedSession(pS.getSession());
            }
            requestWrapper.setContextPath(request.getContextPath());
            if (this.dispatcher != null) {
                this.dispatcher.include((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            }
            if ((ca = responseWrapper.getPortletContent()) == null) {
                ca = new char[]{};
            }
            if (realResponseWrapper.isStreamUsed()) {
                realResponseWrapper.getOutputStream().write(new String(ca).getBytes("utf-8"));
            } else {
                realResponseWrapper.getWriter().write(ca);
            }
        }
        catch (ServletException e) {
            if (e.getRootCause() != null) {
                this.log.error((Object)"Root cause of the exception", e.getRootCause());
            }
            this.log.error((Object)"Problems occur when using PortletDispatcher", (Throwable)e);
            throw new PortletException("Problems occur when using PortletDispatcher", (Throwable)e);
        }
        finally {
            request.removeAttribute("javax.portlet.config");
            request.removeAttribute("javax.portlet.request");
            request.removeAttribute("javax.portlet.response");
            if (requestWrapper != null) {
                requestWrapper.setRedirected(false);
            }
            if (isSharedSessionEnable) {
                requestWrapper.setSharedSession(null);
            }
        }
    }
}

