/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.exoplatform.services.portletcontainer.helper.BasePortletURL;
import org.exoplatform.services.portletcontainer.pci.WindowID;

public class PortletURLImp
extends BasePortletURL {
    private WindowID windowID;
    private String baseURL;
    private String AMPERSAND = "&";

    public PortletURLImp(String type, String markup, List supports, boolean isCurrentlySecured, List customWindowStates, Enumeration supportedWindowState, String baseURL, WindowID windowID) {
        super(type, markup, supports, isCurrentlySecured, customWindowStates, supportedWindowState);
        this.baseURL = baseURL;
        this.windowID = windowID;
    }

    private static String _encode(String s) {
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public String toString() {
        if (!this.setSecureCalled && this.isCurrentlySecured) {
            this.isSecure = true;
        }
        StringBuffer sB = new StringBuffer();
        sB.append(this.baseURL);
        sB.append(this.AMPERSAND);
        sB.append("portal:type");
        sB.append("=");
        sB.append(this.type);
        sB.append(this.AMPERSAND);
        sB.append("portal:isSecure");
        sB.append("=");
        sB.append(this.isSecure);
        if (this.requiredPortletMode != null) {
            sB.append(this.AMPERSAND);
            sB.append("portal:portletMode");
            sB.append("=");
            sB.append(this.requiredPortletMode);
        }
        if (this.requiredWindowState != null) {
            sB.append(this.AMPERSAND);
            sB.append("portal:windowState");
            sB.append("=");
            sB.append(this.requiredWindowState);
        }
        Set names = this.parameters.keySet();
        for (String name : names) {
            Object obj = this.parameters.get(name);
            if (obj instanceof String) {
                String value = (String)obj;
                sB.append(this.AMPERSAND);
                sB.append(PortletURLImp._encode(name));
                sB.append("=");
                sB.append(PortletURLImp._encode(value));
                continue;
            }
            String[] values = (String[])obj;
            for (int i = 0; i < values.length; ++i) {
                sB.append(this.AMPERSAND);
                sB.append(PortletURLImp._encode(name));
                sB.append("=");
                sB.append(PortletURLImp._encode(values[i]));
            }
        }
        return sB.toString();
    }
}

