/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.HttpSessionBindingListenerProxy;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.HttpSessionWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.SharedSessionUtil;

public class SharedSessionWrapper
extends HttpSessionWrapper {
    private static String CREATION_TIME = "javax.portlet.creation-time";
    private static String LAST_ACCESS_TIME = "javax.portlet.last-access-time";
    private static String MAXIMUM_INACTIVE_INTERVAL = "javax.portlet.max-inactive-interval";
    private static int defaultMaximalInterval = 900;
    private String applicationId;

    public SharedSessionWrapper(HttpSession session) {
        super(session);
    }

    public void fillSharedSessionWrapper(HttpSession session, String applicationId) {
        super.setSession(session);
        this.applicationId = applicationId;
    }

    public void emptySharedSessionWrapper() {
        this.applicationId = null;
    }

    public void init() {
        String attCreation = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, CREATION_TIME);
        String attLast = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, LAST_ACCESS_TIME);
        if (super.getAttribute(attCreation) == null) {
            String maxInterval = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, MAXIMUM_INACTIVE_INTERVAL);
            super.setAttribute(attCreation, new Long(System.currentTimeMillis()));
            super.setAttribute(attLast, new Long(System.currentTimeMillis()));
            super.setAttribute(maxInterval, new Integer(defaultMaximalInterval));
        }
    }

    public Object getAttribute(String name) {
        this.setLastAccessTime();
        String key = SharedSessionUtil.encodePortletSessionAttribute(this.applicationId, name);
        Object value = super.getAttribute(key);
        if (value instanceof HttpSessionBindingListenerProxy) {
            return ((HttpSessionBindingListenerProxy)value).getListener();
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        this.setLastAccessTime();
        Enumeration e = super.getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (SharedSessionUtil.isMetaDataAttribute(this.applicationId, s) || !SharedSessionUtil.isAttribute(this.applicationId, s)) continue;
            s = SharedSessionUtil.decodePortletSessionAttribute(this.applicationId, s);
            v.add(s);
        }
        return v.elements();
    }

    public void removeAttribute(String name) {
        String key = SharedSessionUtil.encodePortletSessionAttribute(this.applicationId, name);
        if (super.getAttribute(key) instanceof HttpSessionBindingListenerProxy) {
            HttpSessionBindingListener listener = ((HttpSessionBindingListenerProxy)super.getAttribute(key)).getListener();
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        super.removeAttribute(key);
        this.setLastAccessTime();
    }

    public void removeValue(String name) {
    }

    public void setAttribute(String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            value = new HttpSessionBindingListenerProxy(listener);
        }
        String key = SharedSessionUtil.encodePortletSessionAttribute(this.applicationId, name);
        super.setAttribute(key, value);
        this.setLastAccessTime();
    }

    public long getCreationTime() {
        this.setLastAccessTime();
        String key = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, CREATION_TIME);
        Long creationTime = (Long)super.getAttribute(key);
        return creationTime;
    }

    public int getMaxInactiveInterval() {
        this.setLastAccessTime();
        String key = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, MAXIMUM_INACTIVE_INTERVAL);
        Integer maxInactivInterval = (Integer)super.getAttribute(key);
        return maxInactivInterval;
    }

    public void invalidate() {
        Enumeration e = super.getAttributeNames();
        ArrayList<String> list = new ArrayList<String>(15);
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!SharedSessionUtil.isMetaDataAttribute(this.applicationId, s) && !SharedSessionUtil.isAttribute(this.applicationId, s)) continue;
            list.add(s);
        }
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            super.removeAttribute(name);
        }
    }

    public boolean isNew() {
        this.setLastAccessTime();
        return false;
    }

    public void setMaxInactiveInterval(int i) {
        String key = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, MAXIMUM_INACTIVE_INTERVAL);
        super.setAttribute(key, new Integer(i));
        this.setLastAccessTime();
    }

    private void setLastAccessTime() {
        String attLast = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, LAST_ACCESS_TIME);
        super.setAttribute(attLast, new Long(System.currentTimeMillis()));
    }

    public long getLastAccessedTime() {
        String key = SharedSessionUtil.encodePortletSessionMetaDataAttribute(this.applicationId, LAST_ACCESS_TIME);
        Long lastAccessTime = (Long)super.getAttribute(key);
        if (lastAccessTime == null) {
            return -1L;
        }
        return lastAccessTime;
    }
}

