/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.servlet;

import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletApplicationRegister;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.XMLParser;
import org.exoplatform.services.xml.resolving.SimpleResolvingService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortletApplicationListener
implements ServletContextListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ExoContainer manager = ExoContainerContext.getTopContainer();
        Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        ServletContext servletContext = servletContextEvent.getServletContext();
        log.info((Object)("DEPLOY PORTLET APPLICATION: " + servletContext.getServletContextName()));
        log.debug((Object)("Real path : " + servletContext.getRealPath("")));
        InputStream is = null;
        String oldParser = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
        try {
            is = servletContext.getResourceAsStream("/WEB-INF/portlet.xml");
            if (is == null) {
                log.info((Object)"PORTLET CONFIGURATION IS NOT FOUND, IGNORE THE PACKAGE");
                return;
            }
            PortletApp portletApp = XMLParser.parse((InputStream)is);
            is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            ArrayList<String> roles = new ArrayList<String>();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression roleNameExp = xpath.compile("/web-app/security-role/role-name");
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SimpleResolvingService serviceXML = (SimpleResolvingService)manager.getComponentInstanceOfType(SimpleResolvingService.class);
            builder.setEntityResolver(serviceXML.getEntityResolver());
            Document document = builder.parse(is);
            NodeList nodes = (NodeList)roleNameExp.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node element = nodes.item(i);
                roles.add(element.getFirstChild().getNodeValue());
            }
            log.info((Object)("  -- read: " + portletApp.getPortlet().size() + " portlets"));
            PortletApplicationRegister service = (PortletApplicationRegister)manager.getComponentInstanceOfType(PortletApplicationRegister.class);
            service.registerPortletApplication(servletContext, portletApp, roles);
        }
        catch (Exception e) {
            log.error((Object)("Cannot deploy " + servletContext.getServletContextName()), (Throwable)e);
        }
        finally {
            if (oldParser != null) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldParser);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        ExoContainer manager = ExoContainerContext.getTopContainer();
        Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        log.info((Object)("UNDEPLOY PORTLET APPLICATION: " + servletContext.getServletContextName()));
        try {
            PortletApplicationRegister service = (PortletApplicationRegister)manager.getComponentInstanceOfType(PortletApplicationRegister.class);
            service.removePortletApplication(servletContext);
        }
        catch (Exception e) {
            log.error((Object)("UNDEPLOY PORTLET APPLICATION: " + e));
        }
    }
}

