/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.servlet.ServletContext;
import net.sourceforge.wurfl.wurflapi.ObjectsManager;
import net.sourceforge.wurfl.wurflapi.WurflSource;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainerInitializer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.configuration.MockConfigurationManagerImpl;
import org.exoplatform.container.groovy.GroovyManager;
import org.exoplatform.container.groovy.GroovyManagerContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.monitor.jvm.OperatingSystemInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.util.ExoWurflSource;
import org.exoplatform.test.mocks.servlet.MockServletContext;
import org.picocontainer.PicoContainer;

public class RootContainer
extends ExoContainer {
    private static RootContainer singleton_;
    private static boolean jdk15_;
    private MBeanServer mbeanServer_ = MBeanServerFactory.createMBeanServer("exomx");
    private OperatingSystemInfo osenv_;
    private J2EEServerInfo serverenv_;

    public RootContainer() {
        super(new MX4JComponentAdapterFactory(), null);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        this.serverenv_ = new J2EEServerInfo();
        this.registerComponentInstance(J2EEServerInfo.class, this.serverenv_);
    }

    public OperatingSystemInfo getOSEnvironment() {
        if (this.osenv_ == null) {
            this.osenv_ = (OperatingSystemInfo)this.getComponentInstanceOfType(OperatingSystemInfo.class);
        }
        return this.osenv_;
    }

    public J2EEServerInfo getServerEnvironment() {
        return this.serverenv_;
    }

    public PortalContainer getPortalContainer(String name) {
        J2EEServerInfo senv;
        PortalContainer pcontainer = (PortalContainer)((Object)this.getComponentInstance(name));
        if (pcontainer == null && "standalone".equals((senv = this.getServerEnvironment()).getServerName())) {
            try {
                MockServletContext scontext = new MockServletContext(name);
                pcontainer = new PortalContainer((PicoContainer)this, (ServletContext)scontext);
                MockConfigurationManagerImpl cService = new MockConfigurationManagerImpl((ServletContext)scontext);
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/test-configuration.xml"));
                cService.processRemoveConfiguration();
                pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
                MockConfigurationManagerImpl scService = new MockConfigurationManagerImpl((ServletContext)scontext);
                scService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/session/configuration.xml"));
                scService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/session/test-configuration.xml"));
                scService.processRemoveConfiguration();
                pcontainer.registerComponentInstance("session.container.config", scService);
                GroovyManagerContainer gcontainer = (GroovyManagerContainer)this.getComponentInstanceOfType(GroovyManagerContainer.class);
                URL url = new URL("file:" + this.getServerEnvironment().getServerHome() + "/web/portal/src/webapp/WEB-INF/groovy/");
                GroovyManager gmanager = gcontainer.getGroovyManager(url);
                pcontainer.setGroovyManager(gmanager);
                this.registerComponentInstance(name, (Object)pcontainer);
                ContainerUtil.populateGroovy(pcontainer, cService);
                ContainerUtil.populate(pcontainer, cService);
                pcontainer.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return pcontainer;
    }

    public synchronized PortalContainer createPortalContainer(ServletContext context) {
        try {
            PortalContainer pcontainer = new PortalContainer((PicoContainer)this, context);
            ConfigurationManagerImpl cService = new ConfigurationManagerImpl(context);
            cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            try {
                cService.addConfiguration("war:/conf/configuration.xml");
            }
            catch (Exception ex) {
                // empty catch block
            }
            cService.processRemoveConfiguration();
            pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
            ConfigurationManagerImpl scService = new ConfigurationManagerImpl(context);
            scService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/session/configuration.xml"));
            scService.processRemoveConfiguration();
            pcontainer.registerComponentInstance("session.container.config", scService);
            GroovyManagerContainer gcontainer = (GroovyManagerContainer)this.getComponentInstanceOfType(GroovyManagerContainer.class);
            URL url = new URL("file:" + context.getRealPath("/WEB-INF/groovy") + "/");
            GroovyManager gmanager = gcontainer.getGroovyManager(url);
            pcontainer.setGroovyManager(gmanager);
            this.registerComponentInstance(context.getServletContextName(), (Object)pcontainer);
            PortalContainer.setInstance(pcontainer);
            ContainerUtil.populate(pcontainer, cService);
            pcontainer.start();
            return pcontainer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public synchronized void removePortalContainer(ServletContext servletContext) {
        this.unregisterComponent(servletContext.getServletContextName());
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer_;
    }

    public static Object getComponent(Class key) {
        return RootContainer.getInstance().getComponentInstanceOfType(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RootContainer getInstance() {
        if (singleton_ == null) {
            Class clazz = RootContainer.class;
            synchronized (clazz) {
                if (singleton_ == null) {
                    try {
                        Class.forName("java.lang.management.ManagementFactory");
                        jdk15_ = true;
                    }
                    catch (Exception ex) {
                        jdk15_ = false;
                    }
                    try {
                        String confDir;
                        String overrideConf;
                        File file;
                        singleton_ = new RootContainer();
                        ConfigurationManagerImpl service = new ConfigurationManagerImpl(null);
                        service.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
                        if (jdk15_) {
                            service.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration-jvm15.xml"));
                        }
                        if (System.getProperty("maven.exoplatform.dir") != null) {
                            service.addConfiguration(ContainerUtil.getConfigurationURL("conf/test-configuration.xml"));
                        }
                        if ((file = new File(overrideConf = (confDir = singleton_.getServerEnvironment().getExoConfigurationDirectory()) + "/configuration.xml")).exists()) {
                            service.addConfiguration("file:" + overrideConf);
                        }
                        service.processRemoveConfiguration();
                        singleton_.registerComponentInstance(ConfigurationManager.class, service);
                        ContainerUtil.populate(singleton_, service);
                        List initializers = singleton_.getComponentInstancesOfType(RootContainerInitializer.class);
                        for (int i = 0; i < initializers.size(); ++i) {
                            RootContainerInitializer initializer = (RootContainerInitializer)initializers.get(i);
                            initializer.initialize(singleton_);
                        }
                        ObjectsManager.initMyWay((WurflSource)new ExoWurflSource());
                        singleton_.start();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return singleton_;
    }

    public static boolean isJDK15() {
        return false;
    }

    static class ShutdownThread
    extends Thread {
        RootContainer container_;

        ShutdownThread(RootContainer container) {
            this.container_ = container;
        }

        public void run() {
            this.container_.stop();
        }
    }
}

