/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalListeners;
import org.exoplatform.container.xml.ExternalPlugins;
import org.exoplatform.container.xml.ServiceConfiguration;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    public static final String WAR_CONF_LOCATION = "/WEB-INF";
    protected Configuration configurations_;
    private ServletContext scontext_;

    public ConfigurationManagerImpl(ServletContext context) {
        this.scontext_ = context;
    }

    public void addConfiguration(String url) throws Exception {
        this.addConfiguration(this.getURL(url));
    }

    public void addConfiguration(Collection urls) throws Exception {
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            this.addConfiguration(url);
        }
    }

    public void addConfiguration(URL url) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory((Class)Configuration.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        Configuration conf = (Configuration)uctx.unmarshalDocument(url.openStream(), null);
        if (this.configurations_ == null) {
            this.configurations_ = conf;
        } else {
            this.configurations_.mergeConfiguration(conf);
        }
        List urls = conf.getImports();
        if (urls != null) {
            for (int i = 0; i < urls.size(); ++i) {
                String uri = (String)urls.get(i);
                try {
                    InputStream is = this.getURL(uri).openStream();
                    conf = (Configuration)uctx.unmarshalDocument(is, null);
                    this.configurations_.mergeConfiguration(conf);
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Error: " + ex.getMessage());
                    System.err.println("Error: cannot process the configuration" + url);
                }
            }
        }
    }

    public void processRemoveConfiguration() {
        if (this.configurations_ == null) {
            return;
        }
        List list = this.configurations_.getRemoveConfiguration();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String type = (String)list.get(i);
                this.configurations_.removeServiceConfiguration(type);
            }
        }
    }

    public ServiceConfiguration getServiceConfiguration(String service) throws Exception {
        return this.configurations_.getServiceConfiguration(service);
    }

    public ServiceConfiguration getServiceConfiguration(Class clazz) throws Exception {
        return this.getServiceConfiguration(clazz.getName());
    }

    public Collection getServiceConfigurations() {
        if (this.configurations_ == null) {
            return null;
        }
        return this.configurations_.getServiceConfigurations();
    }

    public Collection getGroovyServiceConfigurations() {
        return this.configurations_.getGroovyServiceConfigurations();
    }

    public Component getComponent(String service) throws Exception {
        return this.configurations_.getComponent(service);
    }

    public Component getComponent(Class clazz) throws Exception {
        return this.configurations_.getComponent(clazz.getName());
    }

    public Collection getComponents() {
        if (this.configurations_ == null) {
            return null;
        }
        return this.configurations_.getComponents();
    }

    public ExternalPlugins getExternalPlugins(String component) throws Exception {
        return this.configurations_.getExternalPlugins(component);
    }

    public ExternalPlugins getExternalPlugins(Class type) throws Exception {
        return this.configurations_.getExternalPlugins(type.getName());
    }

    public ExternalListeners getExternalListeners(String component) throws Exception {
        return this.configurations_.getExternalListeners(component);
    }

    public ExternalListeners getExternalListeners(Class type) throws Exception {
        return this.configurations_.getExternalListeners(type.getName());
    }

    public URL getResource(String url, String defaultURL) throws Exception {
        return null;
    }

    public URL getResource(String uri) throws Exception {
        return this.getURL(uri);
    }

    public InputStream getInputStream(String url, String defaultURL) throws Exception {
        return null;
    }

    public InputStream getInputStream(String uri) throws Exception {
        URL url = this.getURL(uri);
        return url.openStream();
    }

    protected URL getURL(String url) throws Exception {
        if (url.startsWith("jar:")) {
            String path = this.removePrefix("jar:/", url);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResource(path);
        }
        if (url.startsWith("war:")) {
            if (this.scontext_ == null) {
                throw new Exception("unsupport war uri in this configuration service");
            }
            String path = this.removePrefix("war:", url);
            return this.scontext_.getResource(WAR_CONF_LOCATION + path);
        }
        if (url.startsWith("file:")) {
            url = this.resolveSystemProperties(url);
            return new URL(url);
        }
        return null;
    }

    private String resolveSystemProperties(String input) {
        boolean NORMAL = false;
        boolean SEEN_DOLLAR = true;
        int IN_BRACKET = 2;
        if (input == null) {
            return input;
        }
        char[] chars = input.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(input.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value = null;
                String key = input.substring(start + 2, i);
                value = System.getProperty(key);
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return input;
        }
        if (start != chars.length) {
            buffer.append(input.substring(start, chars.length));
        }
        return buffer.toString();
    }

    public boolean isDefault(String value) {
        return value == null || value.length() == 0 || "default".equals(value);
    }

    protected String removePrefix(String prefix, String url) {
        return url.substring(prefix.length(), url.length());
    }
}

