/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.File;
import java.net.URL;
import javax.servlet.ServletContext;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;

public class MockConfigurationManagerImpl
extends ConfigurationManagerImpl {
    private String confDir_;

    public MockConfigurationManagerImpl(ServletContext context) throws Exception {
        super(context);
        File currentDir = new File("");
        String path = currentDir.getAbsolutePath();
        int idx = path.indexOf("exoplatform");
        if (idx < 0) {
            path = System.getProperty("maven.exoplatform.dir") + "/";
            this.confDir_ = path + "/web/portal/src/webapp/WEB-INF";
        } else {
            path = path.substring(0, idx);
            path = path.replace('\\', '/');
            this.confDir_ = path + "exoplatform/web/portal/src/webapp/WEB-INF";
        }
    }

    protected URL getURL(String uri) throws Exception {
        if (uri.startsWith("jar:")) {
            String path = this.removePrefix("jar:/", uri);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResource(path);
        }
        if (uri.startsWith("war:")) {
            String path = this.removePrefix("war:", uri);
            URL url = new URL("file:" + this.confDir_ + path);
            return url;
        }
        if (uri.startsWith("file:")) {
            return new URL(uri);
        }
        return null;
    }
}

