/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor;

public class RequestMonitorData {
    private long minRange_;
    private long maxRange_;
    private int requestCounter_ = 0;
    private long minExecutionTime_ = 0L;
    private long maxExecutionTime_ = 0L;
    private long sumExecutionTime_ = 0L;

    public RequestMonitorData(long minRange, long maxRange) {
        this.minRange_ = minRange;
        this.maxRange_ = maxRange;
    }

    public long minRange() {
        return this.minRange_;
    }

    public long maxRange() {
        return this.maxRange_;
    }

    public int getRequestCounter() {
        return this.requestCounter_;
    }

    public long minExecutionTime() {
        return this.minExecutionTime_;
    }

    public long maxExecutionTime() {
        return this.maxExecutionTime_;
    }

    public long averageExecutionTime() {
        if (this.requestCounter_ <= 0) {
            return 0L;
        }
        return this.sumExecutionTime_ / (long)this.requestCounter_;
    }

    public long sumExecutionTime() {
        return this.sumExecutionTime_;
    }

    public void logRequest(long startTime, long endTime) {
        ++this.requestCounter_;
        if (this.requestCounter_ > 0) {
            long executionTime = endTime - startTime;
            this.sumExecutionTime_ += executionTime;
            if (executionTime < this.minExecutionTime_) {
                this.minExecutionTime_ = executionTime;
            }
            if (executionTime > this.maxExecutionTime_) {
                this.maxExecutionTime_ = executionTime;
            }
        }
    }

    public void logRequest(long executionTime) {
        ++this.requestCounter_;
        if (this.requestCounter_ > 0) {
            this.sumExecutionTime_ += executionTime;
            if (executionTime < this.minExecutionTime_) {
                this.minExecutionTime_ = executionTime;
            }
            if (executionTime > this.maxExecutionTime_) {
                this.maxExecutionTime_ = executionTime;
            }
        }
    }
}

