/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.container.client.ClientInfo;
import org.exoplatform.container.monitor.ActionData;
import org.exoplatform.container.monitor.SessionMonitorListenerStack;

public class SessionMonitor {
    private SessionMonitorListenerStack listeners_;
    private List history_;
    private String error_;
    private int errorCount_ = 0;
    private int actionCount_ = 0;
    private long startTime_;
    private String owner_;
    private ClientInfo clientInfo_ = ClientInfo.DEFAULT;

    public SessionMonitor(SessionMonitorListenerStack listeners, String owner) {
        this.startTime_ = System.currentTimeMillis();
        this.history_ = new LinkedList();
        this.listeners_ = listeners;
        this.owner_ = owner;
    }

    public String getSessionOwner() {
        return this.owner_;
    }

    public void log(ActionData data) {
        if (this.error_ != null) {
            data.setError(this.error_);
        }
        this.history_.add(data);
        this.error_ = null;
        ++this.actionCount_;
        this.listeners_.onLog(this, data);
    }

    public void error(String errorMessage, Throwable t) {
        String trace = "no trace is available";
        if (t != null) {
            trace = ExceptionUtil.getStackTrace((Throwable)t, (int)20);
        }
        this.error_ = this.error_ == null ? errorMessage + "\n" + trace + "\n" : this.error_ + errorMessage + "\n" + trace + "\n";
        ++this.errorCount_;
        this.listeners_.onError(this, errorMessage, t);
    }

    public List getHistory() {
        return this.history_;
    }

    public List emptyHistory() {
        return this.history_;
    }

    public SessionMonitorListenerStack getListeners() {
        return this.listeners_;
    }

    public int getErrorCount() {
        return this.errorCount_;
    }

    public int getActionCount() {
        return this.actionCount_;
    }

    public String getRemoteUser() {
        return this.clientInfo_.getRemoteUser();
    }

    public String getIPAddress() {
        return this.clientInfo_.getIpAddress();
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo_;
    }

    public void setClientInfo(ClientInfo ci) {
        this.clientInfo_ = ci;
    }

    public long getAccessTime() {
        return this.startTime_;
    }

    public long getLiveTime() {
        return System.currentTimeMillis() - this.startTime_;
    }

    public long getLiveTimeInMinute() {
        return (System.currentTimeMillis() - this.startTime_) / 60000L;
    }

    public long getLiveTimeInSecond() {
        return (System.currentTimeMillis() - this.startTime_) / 1000L;
    }
}

