/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.task.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.task.Task;
import org.exoplatform.services.task.TaskService;
import org.picocontainer.Startable;

public class TaskServiceImpl
implements TaskService,
Startable {
    private static Collection EMPTY = new LinkedList();
    private Collection repeatTasks_;
    private Collection tasks_;
    private Log log_;
    private TaskThread thread_;
    static /* synthetic */ Class class$org$exoplatform$services$database$HibernateService;

    public TaskServiceImpl(LogService lservice) {
        this.log_ = lservice.getLog(this.getClass());
        this.repeatTasks_ = new LinkedList();
        this.tasks_ = new LinkedList();
    }

    public synchronized void queueTask(Task task) {
        this.tasks_.add(task);
    }

    public synchronized Collection getTasks() {
        if (this.tasks_.size() == 0) {
            return EMPTY;
        }
        return new LinkedList(this.tasks_);
    }

    synchronized Collection dequeueTasks() {
        if (this.tasks_.size() == 0) {
            return EMPTY;
        }
        Collection temp = this.tasks_;
        this.tasks_ = new LinkedList();
        return temp;
    }

    public synchronized void queueRepeatTask(Task task) {
        this.repeatTasks_.add(task);
    }

    public synchronized Collection getRepeatTasks() {
        if (this.repeatTasks_.size() == 0) {
            return EMPTY;
        }
        return new LinkedList(this.repeatTasks_);
    }

    synchronized Collection dequeueRepeatTasks() {
        if (this.repeatTasks_.size() == 0) {
            return EMPTY;
        }
        return new LinkedList(this.repeatTasks_);
    }

    public synchronized void removeRepeatTask(Task task) {
        this.repeatTasks_.remove(task);
    }

    public void start() {
        this.thread_ = new TaskThread(1000L);
        this.thread_.setDaemon(true);
        this.thread_.start();
    }

    public void stop() {
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
    }

    void runTasks(Collection tasks) {
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            Task task = (Task)i.next();
            try {
                PortalContainer pcontainer = task.getPortalContainer();
                if (pcontainer != null) {
                    PortalContainer.setInstance((PortalContainer)pcontainer);
                }
                task.execute();
                if (pcontainer == null) continue;
                HibernateService hservice = (HibernateService)pcontainer.getComponentInstanceOfType(class$org$exoplatform$services$database$HibernateService == null ? TaskServiceImpl.class$("org.exoplatform.services.database.HibernateService") : class$org$exoplatform$services$database$HibernateService);
                if (hservice != null) {
                    hservice.closeSession();
                }
                PortalContainer.setInstance(null);
            }
            catch (Throwable t) {
                String error = "task: " + task.getName() + "\n task description: " + task.getDescription();
                this.log_.error((Object)error, t);
            }
        }
    }

    public class TaskThread
    extends Thread {
        private long period_;

        public TaskThread(long period) {
            this.setPriority(5);
            this.period_ = period;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        TaskThread.sleep(this.period_);
                        TaskServiceImpl.this.runTasks(TaskServiceImpl.this.dequeueTasks());
                        TaskServiceImpl.this.runTasks(TaskServiceImpl.this.dequeueRepeatTasks());
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

