/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.threadpool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.threadpool.ThreadPoolService;
import org.exoplatform.services.threadpool.impl.DefaultThreadFactory;
import org.exoplatform.services.threadpool.impl.Queue;
import org.exoplatform.services.threadpool.impl.ThreadFactoryIF;

public class ThreadPoolServiceImpl
implements ThreadPoolService {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = 500;
    public static final int DEFAULT_NORMALPOOLSIZE = 1;
    public static final long DEFAULT_MAXIDLETIME = 60000L;
    protected volatile int maximumPoolSize = 500;
    protected volatile int normalPoolSize = 1;
    protected long maxIdleTime = 60000L;
    protected Queue handOff;
    protected Object poolLock = new Object();
    protected volatile int poolSize = 0;
    protected Map threads;
    private ThreadFactoryIF threadFactory = new DefaultThreadFactory();
    private Log log;
    protected BlockedExecutionStrategy blockedExecutionStrategy;

    public ThreadPoolServiceImpl(LogService logService) {
        this.log = logService.getLog("org.exoplatform.services.threadpool");
        this.maximumPoolSize = 500;
        this.handOff = new Queue();
        this.runWhenBlocked();
        this.threads = new HashMap();
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = newMaximum;
    }

    public int getNormalPoolSize() {
        return this.normalPoolSize;
    }

    public void setNormalPoolSize(int newNormal) {
        if (newNormal < 0) {
            throw new IllegalArgumentException();
        }
        this.normalPoolSize = newNormal;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setThreadFactory(ThreadFactoryIF newValue) {
        this.threadFactory = newValue;
    }

    protected ThreadFactoryIF getThreadFactory() {
        return this.threadFactory;
    }

    protected void addThread(Runnable task) {
        ++this.poolSize;
        Worker worker = new Worker(task);
        Thread thread = this.getThreadFactory().createThread(worker);
        this.threads.put(worker, thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int numberOfThreads) {
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            Object object = this.poolLock;
            synchronized (object) {
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    ++ncreated;
                } else {
                    break;
                }
                this.addThread(null);
                continue;
            }
        }
        return ncreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        Object object = this.poolLock;
        synchronized (object) {
            Iterator it = this.threads.values().iterator();
            while (it.hasNext()) {
                Thread t = (Thread)it.next();
                t.interrupt();
            }
        }
    }

    public List drain() {
        boolean wasInterrupted = false;
        Vector<Object> tasks = new Vector<Object>();
        while (true) {
            try {
                Object x;
                while ((x = this.handOff.get(0L)) != null) {
                    tasks.addElement(x);
                }
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return tasks;
    }

    public synchronized long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized void setMaxIdleTime(long msecs) {
        this.maxIdleTime = msecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workerDone(Worker w) {
        Object object = this.poolLock;
        synchronized (object) {
            --this.poolSize;
            this.threads.remove(w);
        }
    }

    protected Runnable getTask() throws InterruptedException {
        long waitTime = this.getMaxIdleTime();
        if (waitTime >= 0L) {
            return (Runnable)this.handOff.get(waitTime);
        }
        return (Runnable)this.handOff.get();
    }

    protected synchronized BlockedExecutionStrategy getBlockedExecutionStrategy() {
        return this.blockedExecutionStrategy;
    }

    public synchronized void runWhenBlocked() {
        this.blockedExecutionStrategy = new RunWhenBlocked();
    }

    public synchronized void WhenBlocked() {
        this.blockedExecutionStrategy = new WaitWhenBlocked();
    }

    public synchronized void discardWhenBlocked() {
        this.blockedExecutionStrategy = new DiscardWhenBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task) throws InterruptedException {
        this.log.debug((Object)"execute method called");
        do {
            Object object = this.poolLock;
            synchronized (object) {
                if (this.getPoolSize() < this.getNormalPoolSize()) {
                    this.addThread(task);
                    return;
                }
                if (this.handOff.put(task, 0L)) {
                    return;
                }
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    this.addThread(task);
                    return;
                }
            }
        } while (!this.getBlockedExecutionStrategy().blockedAction(task));
    }

    protected class DiscardWhenBlocked
    implements BlockedExecutionStrategy {
        protected DiscardWhenBlocked() {
        }

        public boolean blockedAction(Runnable task) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    implements BlockedExecutionStrategy {
        protected WaitWhenBlocked() {
        }

        public boolean blockedAction(Runnable task) {
            try {
                ThreadPoolServiceImpl.this.handOff.put(task);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    protected class RunWhenBlocked
    implements BlockedExecutionStrategy {
        protected RunWhenBlocked() {
        }

        public boolean blockedAction(Runnable task) {
            task.run();
            return true;
        }
    }

    protected static interface BlockedExecutionStrategy {
        public boolean blockedAction(Runnable var1);
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                if (task != null) {
                    task.run();
                }
                while (ThreadPoolServiceImpl.this.getPoolSize() <= ThreadPoolServiceImpl.this.getMaximumPoolSize() && (task = ThreadPoolServiceImpl.this.getTask()) != null) {
                    task.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                ThreadPoolServiceImpl.this.workerDone(this);
            }
        }
    }
}

