/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core;

public class ImageShapeStyle {
    private static final String STYLE_DELIMITER = ";";
    private static final String WIDTH_TOKEN = "width:";
    private static final String HEIGHT_TOKEN = "height:";
    private float height;
    private float width;
    private boolean canUse;

    private ImageShapeStyle(float height, float width, boolean canUse) {
        this.height = height;
        this.width = width;
        this.canUse = canUse;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isCanUse() {
        return this.canUse;
    }

    public static ImageShapeStyle parse(String style) {
        float height = 10.0f;
        float width = 10.0f;
        String[] tokens = style.split(STYLE_DELIMITER);
        int count = 0;
        for (String token : tokens) {
            if ((token = token.trim()).startsWith(WIDTH_TOKEN)) {
                token = token.substring(WIDTH_TOKEN.length());
                token = token.substring(0, token.length() - 2);
                try {
                    width = Float.parseFloat(token);
                    ++count;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!token.startsWith(HEIGHT_TOKEN)) continue;
            token = token.substring(HEIGHT_TOKEN.length());
            token = token.substring(0, token.length() - 2);
            try {
                height = Float.parseFloat(token);
                ++count;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ImageShapeStyle(height, width, count == 2);
    }
}

