/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core;

import fr.opensagres.poi.xwpf.converter.core.IMasterPageHandler;
import fr.opensagres.poi.xwpf.converter.core.IXWPFMasterPage;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSettings;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;

public class MasterPageManager
extends LinkedList<CTSectPr> {
    private final CTDocument1 document;
    private final IMasterPageHandler documentHandler;
    private final CTSectPr bodySectPr;
    private CTSectPr currentSectPr;
    private final Map<CTSectPr, IXWPFMasterPage> masterPages;
    private boolean initialized;
    private boolean changeSection;
    private int nbPages;
    private IXWPFMasterPage currentMasterPage;
    private final boolean evenAndOddHeaders;
    private Map<Integer, Object> headers;
    private Map<Integer, Object> footers;

    public MasterPageManager(CTDocument1 document, IMasterPageHandler visitor) throws Exception {
        this.document = document;
        this.documentHandler = visitor;
        this.bodySectPr = document.getBody().getSectPr();
        this.masterPages = new HashMap<CTSectPr, IXWPFMasterPage>();
        this.initialized = false;
        this.changeSection = false;
        this.nbPages = 0;
        this.evenAndOddHeaders = this.isEventAndOddHeaders(visitor.getStylesDocument());
        this.headers = Collections.EMPTY_MAP;
        this.footers = Collections.EMPTY_MAP;
    }

    public void initialize() throws Exception {
        this.initialized = true;
        this.compute(this.document);
        if (this.isEmpty()) {
            this.currentSectPr = this.bodySectPr;
            this.addSection(this.currentSectPr, false);
            this.fireSectionChanged(this.currentSectPr);
        } else {
            this.currentSectPr = (CTSectPr)super.poll();
            this.fireSectionChanged(this.currentSectPr);
        }
    }

    private void compute(CTDocument1 document) throws Exception {
        XmlCursor cursor = document.getBody().newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            CTP paragraph;
            CTSectPr sectPr;
            XmlObject o = cursor.getObject();
            if (!(o instanceof CTP) || (sectPr = this.getSectPr(paragraph = (CTP)o)) == null) continue;
            this.addSection(sectPr, true);
        }
        this.addSection(this.bodySectPr, false);
    }

    public CTSectPr getBodySectPr() {
        return this.bodySectPr;
    }

    public void update(CTP paragraph) {
        if (this.changeSection) {
            this.changeSection = false;
            if (!this.isEmpty()) {
                this.currentSectPr = (CTSectPr)super.poll();
                this.fireSectionChanged(this.currentSectPr);
            } else {
                this.currentSectPr = this.bodySectPr;
                this.fireSectionChanged(this.currentSectPr);
            }
        } else {
            CTSectPr sectPr = this.getSectPr(paragraph);
            if (sectPr != null) {
                this.currentSectPr = sectPr;
                this.changeSection = true;
            }
        }
    }

    private void fireSectionChanged(CTSectPr sectPr) {
        this.currentMasterPage = this.getMasterPage(sectPr);
        this.documentHandler.setActiveMasterPage(this.currentMasterPage);
    }

    private void addSection(CTSectPr sectPr, boolean pushIt) throws Exception {
        if (pushIt) {
            super.add(sectPr);
        }
        Object masterPage = this.documentHandler.createMasterPage(sectPr);
        this.visitHeadersFooters((IXWPFMasterPage)masterPage, sectPr);
        this.masterPages.put(sectPr, (IXWPFMasterPage)masterPage);
    }

    private void visitHeadersFooters(IXWPFMasterPage masterPage, CTSectPr sectPr) throws Exception {
        int typeValue;
        STHdrFtr type;
        boolean titlePage = XWPFUtils.isCTOnOff(sectPr.getTitlePg());
        Map<Integer, Object> previousHeaders = this.headers;
        Map<Integer, Object> previousFooters = this.footers;
        this.headers = new HashMap<Integer, Object>();
        this.footers = new HashMap<Integer, Object>();
        for (CTHdrFtrRef reference : sectPr.getHeaderReferenceList()) {
            type = reference.xgetType();
            int n = typeValue = type == null ? 2 : type.enumValue().intValue();
            if (typeValue == 3 && !titlePage) continue;
            masterPage.setType(typeValue);
            this.documentHandler.visitHeaderRef(reference, sectPr, masterPage);
            masterPage.setType(typeValue);
            this.headers.put(typeValue, masterPage.getHeader());
        }
        for (CTHdrFtrRef reference : sectPr.getFooterReferenceList()) {
            type = reference.xgetType();
            int n = typeValue = type == null ? 2 : type.enumValue().intValue();
            if (typeValue == 3 && !titlePage) continue;
            masterPage.setType(typeValue);
            this.documentHandler.visitFooterRef(reference, sectPr, masterPage);
            masterPage.setType(typeValue);
            this.footers.put(typeValue, masterPage.getFooter());
        }
        if (titlePage) {
            this.inheritHeader(masterPage, 3, previousHeaders);
            this.inheritFooter(masterPage, 3, previousFooters);
        }
        if (this.evenAndOddHeaders) {
            this.inheritHeader(masterPage, 1, previousHeaders);
            this.inheritFooter(masterPage, 1, previousFooters);
        }
        this.inheritHeader(masterPage, 2, previousHeaders);
        this.inheritFooter(masterPage, 2, previousFooters);
        masterPage.setType(3);
    }

    private void inheritHeader(IXWPFMasterPage<Object> masterPage, int type, Map<Integer, Object> previousHeaders) {
        Object header;
        if (!this.headers.containsKey(type) && (header = previousHeaders.get(type)) != null) {
            masterPage.setType(type);
            masterPage.setHeader(header);
            this.headers.put(type, header);
        }
    }

    private void inheritFooter(IXWPFMasterPage<Object> masterPage, int type, Map<Integer, Object> previousFooters) {
        Object footer;
        if (!this.footers.containsKey(type) && (footer = previousFooters.get(type)) != null) {
            masterPage.setType(type);
            masterPage.setFooter(footer);
            this.footers.put(type, footer);
        }
    }

    private CTSectPr getSectPr(CTP paragraph) {
        CTPPr ppr = paragraph.getPPr();
        if (ppr != null) {
            return ppr.getSectPr();
        }
        return null;
    }

    public IXWPFMasterPage getMasterPage(CTSectPr sectPr) {
        return this.masterPages.get(sectPr);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void onNewPage() {
        if (this.currentMasterPage != null) {
            int oldType = this.currentMasterPage.getType();
            int newType = 2;
            if (this.evenAndOddHeaders) {
                if (this.nbPages % 2 == 0) {
                    newType = 1;
                }
                ++this.nbPages;
            }
            if (oldType != newType) {
                this.currentMasterPage.setType(newType);
            }
        }
    }

    private boolean isEventAndOddHeaders(XWPFStylesDocument stylesDocument) {
        if (stylesDocument == null) {
            return false;
        }
        CTSettings settings = stylesDocument.getCTSettings();
        if (settings == null) {
            return false;
        }
        return XWPFUtils.isCTOnOff(settings.getEvenAndOddHeaders());
    }
}

